/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.viewer;

import de.bioforscher.singa.javafx.viewer.ColorScheme;
import de.bioforscher.singa.javafx.viewer.MaterialProvider;
import de.bioforscher.singa.javafx.viewer.XForm;
import de.bioforscher.singa.mathematics.geometry.bodies.Cube;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.mathematics.vectors.Vectors3D;
import de.bioforscher.singa.structure.model.interfaces.Atom;
import de.bioforscher.singa.structure.model.interfaces.Chain;
import de.bioforscher.singa.structure.model.interfaces.LeafSubstructure;
import de.bioforscher.singa.structure.model.interfaces.Model;
import de.bioforscher.singa.structure.model.oak.OakBond;
import de.bioforscher.singa.structure.model.oak.OakChain;
import de.bioforscher.singa.structure.model.oak.OakLeafSubstructure;
import de.bioforscher.singa.structure.model.oak.OakModel;
import de.bioforscher.singa.structure.model.oak.OakStructure;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.scene.Camera;
import javafx.scene.DepthTest;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.control.Button;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.Paint;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.Sphere;
import javafx.scene.transform.Rotate;
import javafx.stage.Stage;

public class StructureViewer
extends Application {
    private static final double CAMERA_INITIAL_DISTANCE = -450.0;
    private static final double CAMERA_INITIAL_X_ANGLE = 70.0;
    private static final double CAMERA_INITIAL_Y_ANGLE = 320.0;
    private static final double CAMERA_NEAR_CLIP = 0.1;
    private static final double CAMERA_FAR_CLIP = 10000.0;
    private static final double CONTROL_MULTIPLIER = 0.1;
    private static final double SHIFT_MULTIPLIER = 10.0;
    private static final double MOUSE_SPEED = 0.1;
    private static final double ROTATION_SPEED = 2.0;
    private static final double TRACK_SPEED = 0.3;
    public static OakStructure structure;
    public static List<de.bioforscher.singa.mathematics.geometry.bodies.Sphere> spheres;
    public static List<Cube> cubes;
    public static ColorScheme colorScheme;
    private final Group displayGroup = new Group();
    private final PerspectiveCamera camera = new PerspectiveCamera(true);
    private final XForm XYRotate = new XForm();
    private final XForm XYTranslate = new XForm();
    private final XForm ZRotate = new XForm();
    private OakStructure displayStructure;
    private Map<String, PhongMaterial> chainMaterials;
    private XForm world = new XForm();
    private XForm moleculeGroup = new XForm();
    private double mousePosX;
    private double mousePosY;
    private double mouseOldX;
    private double mouseOldY;
    private double mouseDeltaX;
    private double mouseDeltaY;
    private TreeView<String> treeView;
    private Vector3D centroid;

    public static void main(String[] args) {
        StructureViewer.launch((String[])args);
    }

    public void start(Stage primaryStage) {
        this.chainMaterials = new HashMap<String, PhongMaterial>();
        this.treeView = new TreeView();
        this.treeView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.toogleDisplay((String)newValue.getValue());
            }
        });
        this.displayGroup.getChildren().add((Object)this.world);
        this.displayGroup.setDepthTest(DepthTest.ENABLE);
        if (structure != null) {
            if (structure.getAllModels().size() > 1) {
                this.displayStructure = new OakStructure();
                this.displayStructure.addModel((OakModel)structure.getAllModels().get(0));
            } else {
                this.displayStructure = structure;
            }
            this.fillTree();
            this.translateToCentre();
            this.buildDisplayedStructure();
        }
        this.buildCamera();
        SubScene structureScene = new SubScene((Parent)this.displayGroup, 800.0, 600.0, true, SceneAntialiasing.BALANCED);
        this.handleKeyboard(structureScene);
        this.handleMouse(structureScene);
        structureScene.setFill((Paint)Color.WHITE);
        Button showSpheres = new Button("Show Spheres");
        showSpheres.setOnAction(this::buildSpheres);
        Button showCubes = new Button("Show Boxes");
        showCubes.setOnAction(this::buildCubes);
        VBox vbox = new VBox(new Node[]{this.treeView, showSpheres, showCubes});
        SplitPane pane = new SplitPane(new Node[]{structureScene, vbox});
        Scene mainScene = new Scene((Parent)pane);
        primaryStage.setTitle("Singa Molecule Viewer");
        primaryStage.setScene(mainScene);
        primaryStage.show();
        structureScene.setCamera((Camera)this.camera);
    }

    private void buildCamera() {
        this.displayGroup.getChildren().add((Object)this.XYRotate);
        this.XYRotate.getChildren().add((Object)this.XYTranslate);
        this.XYTranslate.getChildren().add((Object)this.ZRotate);
        this.ZRotate.getChildren().add((Object)this.camera);
        this.ZRotate.setRotateZ(180.0);
        this.camera.setNearClip(0.1);
        this.camera.setFarClip(10000.0);
        this.camera.setTranslateZ(-450.0);
        this.XYRotate.ry.setAngle(320.0);
        this.XYRotate.rx.setAngle(70.0);
    }

    private void translateToCentre() {
        List allAtoms = structure.getAllAtoms();
        this.centroid = Vectors3D.getCentroid((Collection)allAtoms.stream().map(Atom::getPosition).collect(Collectors.toList())).multiply(3.0);
        allAtoms.forEach(atom -> atom.setPosition(atom.getPosition().multiply(3.0).subtract(this.centroid)));
    }

    private void buildDisplayedStructure() {
        this.displayStructure.getAllLeafSubstructures().stream().map(OakLeafSubstructure.class::cast).forEach(this::addLeafSubstructure);
        this.world.getChildren().addAll((Object[])new Node[]{this.moleculeGroup});
    }

    private void addLeafSubstructure(OakLeafSubstructure<?> leafSubstructure) {
        leafSubstructure.getAllAtoms().forEach(atom -> this.addAtom((LeafSubstructure<?>)leafSubstructure, (Atom)atom));
        leafSubstructure.getBonds().forEach(bond -> this.addLeafBond((LeafSubstructure)leafSubstructure, (OakBond)bond));
    }

    private void addAtom(LeafSubstructure<?> origin, Atom atom) {
        Sphere atomShape = new Sphere(1.0);
        atomShape.setMaterial((Material)this.getMaterial(origin, atom));
        atomShape.setTranslateX(atom.getPosition().getX());
        atomShape.setTranslateY(atom.getPosition().getY());
        atomShape.setTranslateZ(atom.getPosition().getZ());
        Tooltip tooltip = new Tooltip(atom.getElement().getName() + " (" + atom.getAtomName() + ":" + atom.getAtomIdentifier() + ") of " + origin.getFamily().getThreeLetterCode() + ":" + origin.getIdentifier());
        Tooltip.install((Node)atomShape, (Tooltip)tooltip);
        this.moleculeGroup.getChildren().add((Object)atomShape);
    }

    private void fillTree() {
        TreeItem rootItem = new TreeItem((Object)structure.getPdbIdentifier());
        for (Model model : structure.getAllModels()) {
            TreeItem modelNode = new TreeItem((Object)("Model: " + String.valueOf(model.getModelIdentifier())));
            model.getAllChains().stream().sorted(Comparator.comparing(Chain::getChainIdentifier)).forEach(chain -> {
                TreeItem chainNode = new TreeItem((Object)("Chain: " + String.valueOf(chain.getChainIdentifier())));
                modelNode.getChildren().add((Object)chainNode);
            });
            rootItem.getChildren().add((Object)modelNode);
        }
        this.treeView.setRoot(rootItem);
    }

    private void toogleDisplay(String identifier) {
        if (identifier.contains("Model")) {
            this.displayModel(identifier);
        } else if (identifier.contains("Chain")) {
            this.displayChain(identifier);
        }
    }

    private void displayModel(String identifier) {
        this.displayStructure = new OakStructure();
        this.world = new XForm();
        this.moleculeGroup = new XForm();
        this.displayStructure.addModel((OakModel)structure.getModel(Integer.valueOf(identifier.replace("Model: ", "")).intValue()).get());
        this.buildDisplayedStructure();
        this.displayGroup.getChildren().retainAll((Object[])new Node[0]);
        this.displayGroup.getChildren().add((Object)this.world);
    }

    private void displayChain(String identifier) {
        this.displayStructure = new OakStructure();
        this.world = new XForm();
        this.moleculeGroup = new XForm();
        OakChain chain = (OakChain)structure.getAllChains().stream().filter(aChain -> aChain.getChainIdentifier().equals(identifier.replace("Chain: ", ""))).findAny().orElseThrow(() -> new IllegalStateException("Chould not retrieve chainIdentifier " + identifier.replace("Chain: ", "")));
        OakModel model = new OakModel(1);
        model.addChain(chain);
        this.displayStructure.addModel(model);
        this.buildDisplayedStructure();
        this.displayGroup.getChildren().retainAll((Object[])new Node[0]);
        this.displayGroup.getChildren().add((Object)this.world);
    }

    private void addLeafBond(LeafSubstructure origin, OakBond bond) {
        Cylinder bondShape = this.createCylinderConnecting(bond.getSource().getPosition(), bond.getTarget().getPosition());
        bondShape.setMaterial((Material)this.getMaterial(origin, bond));
        this.moleculeGroup.getChildren().add((Object)bondShape);
    }

    private void addChainBond(Chain origin, OakBond bond) {
        Cylinder bondShape = this.createCylinderConnecting(bond.getSource().getPosition(), bond.getTarget().getPosition());
        bondShape.setMaterial((Material)this.getMaterial(origin, bond));
        this.moleculeGroup.getChildren().add((Object)bondShape);
    }

    private Cylinder createCylinderConnecting(Vector3D source, Vector3D target) {
        Vector3D delta = target.subtract(source);
        double distance = source.distanceTo((Vector)target);
        Cylinder bond = new Cylinder(0.4, distance, 10);
        Vector3D newLocation = delta.divide(2.0).add(source);
        bond.setTranslateX(newLocation.getX());
        bond.setTranslateY(newLocation.getY());
        bond.setTranslateZ(newLocation.getZ());
        bond.getTransforms().add((Object)new Rotate(90.0 + Math.toDegrees(Math.atan2(delta.getY(), delta.getX())), Rotate.Z_AXIS));
        bond.getTransforms().add((Object)new Rotate(90.0 + Math.toDegrees(Math.acos(delta.getZ() / distance)), Rotate.X_AXIS));
        return bond;
    }

    private PhongMaterial getMaterial(LeafSubstructure origin, Atom atom) {
        switch (colorScheme) {
            case BY_ELEMENT: {
                return MaterialProvider.getDefaultMaterialForElement(atom.getElement());
            }
            case BY_FAMILY: {
                return MaterialProvider.getMaterialForType(origin.getFamily());
            }
        }
        String chain = origin.getIdentifier().getChainIdentifier();
        if (this.chainMaterials.containsKey(chain)) {
            return this.chainMaterials.get(chain);
        }
        return this.getMaterialForChain(origin.getIdentifier().getChainIdentifier());
    }

    private PhongMaterial getMaterial(LeafSubstructure origin, OakBond edge) {
        switch (colorScheme) {
            case BY_ELEMENT: {
                return MaterialProvider.CARBON;
            }
            case BY_FAMILY: {
                return MaterialProvider.getMaterialForType(origin.getFamily());
            }
        }
        return this.getMaterialForChain(origin.getIdentifier().getChainIdentifier());
    }

    private PhongMaterial getMaterial(Chain origin, OakBond edge) {
        if (colorScheme == ColorScheme.BY_ELEMENT) {
            return MaterialProvider.CARBON;
        }
        return this.getMaterialForChain(origin.getChainIdentifier());
    }

    private PhongMaterial getMaterialForChain(String chain) {
        if (this.chainMaterials.containsKey(chain)) {
            return this.chainMaterials.get(chain);
        }
        PhongMaterial material = MaterialProvider.crateMaterialFromColor(Color.color((double)Math.random(), (double)Math.random(), (double)Math.random()));
        this.chainMaterials.put(chain, material);
        return material;
    }

    private void buildSpheres(ActionEvent event) {
        Tooltip tooltip;
        this.world = new XForm();
        this.moleculeGroup = new XForm();
        for (de.bioforscher.singa.mathematics.geometry.bodies.Sphere sphere : spheres) {
            Sphere sphereShape = new Sphere(sphere.getRadius());
            sphereShape.setMaterial((Material)MaterialProvider.crateMaterialFromColor(Color.LIGHTSKYBLUE));
            sphereShape.setTranslateX(sphere.getCenter().getX());
            sphereShape.setTranslateY(sphere.getCenter().getY());
            sphereShape.setTranslateZ(sphere.getCenter().getZ());
            tooltip = new Tooltip(sphere.toString());
            Tooltip.install((Node)sphereShape, (Tooltip)tooltip);
            this.moleculeGroup.getChildren().add((Object)sphereShape);
        }
        for (Cube cube : cubes) {
            Box boxShape = new Box(cube.getSideLength(), cube.getSideLength(), cube.getSideLength());
            boxShape.setMaterial((Material)MaterialProvider.crateMaterialFromColor(Color.LIGHTSALMON));
            boxShape.setTranslateX(cube.getCenter().getX());
            boxShape.setTranslateY(cube.getCenter().getY());
            boxShape.setTranslateZ(cube.getCenter().getZ());
            tooltip = new Tooltip(cube.toString());
            Tooltip.install((Node)boxShape, (Tooltip)tooltip);
            this.moleculeGroup.getChildren().add((Object)boxShape);
        }
        this.world.getChildren().add((Object)this.moleculeGroup);
        this.displayGroup.getChildren().retainAll((Object[])new Node[0]);
        this.displayGroup.getChildren().add((Object)this.world);
    }

    private void buildCubes(ActionEvent event) {
        this.world = new XForm();
        this.moleculeGroup = new XForm();
        for (Cube cube : cubes) {
            Box boxShape = new Box(cube.getSideLength(), cube.getSideLength(), cube.getSideLength());
            boxShape.setMaterial((Material)MaterialProvider.crateMaterialFromColor(Color.LIGHTSALMON));
            boxShape.setTranslateX(cube.getCenter().getX());
            boxShape.setTranslateY(cube.getCenter().getY());
            boxShape.setTranslateZ(cube.getCenter().getZ());
            Tooltip tooltip = new Tooltip(cube.toString());
            Tooltip.install((Node)boxShape, (Tooltip)tooltip);
            this.moleculeGroup.getChildren().add((Object)boxShape);
        }
        this.world.getChildren().add((Object)this.moleculeGroup);
        this.displayGroup.getChildren().retainAll((Object[])new Node[0]);
        this.displayGroup.getChildren().add((Object)this.world);
    }

    private void handleMouse(SubScene scene) {
        scene.setOnMousePressed(me -> {
            this.mousePosX = me.getSceneX();
            this.mousePosY = me.getSceneY();
            this.mouseOldX = me.getSceneX();
            this.mouseOldY = me.getSceneY();
        });
        scene.setOnMouseDragged(me -> {
            this.mouseOldX = this.mousePosX;
            this.mouseOldY = this.mousePosY;
            this.mousePosX = me.getSceneX();
            this.mousePosY = me.getSceneY();
            this.mouseDeltaX = this.mousePosX - this.mouseOldX;
            this.mouseDeltaY = this.mousePosY - this.mouseOldY;
            double modifier = 1.0;
            if (me.isControlDown()) {
                modifier = 0.1;
            }
            if (me.isShiftDown()) {
                modifier = 10.0;
            }
            if (me.isPrimaryButtonDown()) {
                this.XYRotate.ry.setAngle(this.XYRotate.ry.getAngle() - this.mouseDeltaX * 0.1 * modifier * 2.0);
                this.XYRotate.rx.setAngle(this.XYRotate.rx.getAngle() + this.mouseDeltaY * 0.1 * modifier * 2.0);
            } else if (me.isSecondaryButtonDown()) {
                double z = this.camera.getTranslateZ();
                double newZ = z + this.mouseDeltaX * 0.1 * modifier;
                this.camera.setTranslateZ(newZ);
            } else if (me.isMiddleButtonDown()) {
                this.XYTranslate.translate.setX(this.XYTranslate.translate.getX() + this.mouseDeltaX * 0.1 * modifier * 0.3);
                this.XYTranslate.translate.setY(this.XYTranslate.translate.getY() + this.mouseDeltaY * 0.1 * modifier * 0.3);
            }
        });
    }

    private void handleKeyboard(SubScene scene) {
        scene.setOnKeyPressed(event -> {
            switch (event.getCode()) {
                case R: {
                    this.XYTranslate.translate.setX(0.0);
                    this.XYTranslate.translate.setY(0.0);
                    this.camera.setTranslateZ(-450.0);
                    this.XYRotate.ry.setAngle(320.0);
                    this.XYRotate.rx.setAngle(70.0);
                }
            }
        });
    }

    static {
        colorScheme = ColorScheme.BY_CHAIN;
    }
}

