/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.viewer;

import de.bioforscher.singa.chemistry.descriptive.features.smiles.SmilesParser;
import de.bioforscher.singa.javafx.renderer.graphs.GraphDisplayApplication;
import de.bioforscher.singa.javafx.renderer.molecules.MoleculeGraphRenderer;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import de.bioforscher.singa.structure.algorithms.molecules.MoleculeIsomorphism;
import de.bioforscher.singa.structure.algorithms.molecules.MoleculeIsomorphismFinder;
import de.bioforscher.singa.structure.model.identifiers.LeafIdentifier;
import de.bioforscher.singa.structure.model.interfaces.Structure;
import de.bioforscher.singa.structure.model.molecules.MoleculeAtom;
import de.bioforscher.singa.structure.model.molecules.MoleculeBond;
import de.bioforscher.singa.structure.model.molecules.MoleculeGraph;
import de.bioforscher.singa.structure.model.molecules.MoleculeGraphs;
import de.bioforscher.singa.structure.model.oak.OakLeafSubstructure;
import de.bioforscher.singa.structure.parser.pdb.structures.StructureParser;
import java.util.Optional;
import java.util.function.BiFunction;
import javafx.application.Application;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class MoleculeIsomorphismTest {
    public static void main(String[] args) {
        Structure structure = StructureParser.pdb().pdbIdentifier("1jjc").parse();
        MoleculeGraph phenylAlaninePattern = SmilesParser.parse((String)"C1=CC=C(C=C1)CC(C=O)N");
        Optional fa5 = structure.getLeafSubstructure(new LeafIdentifier("1jjc", 1, "A", 999));
        MoleculeGraph fa5Graph = MoleculeGraphs.createMoleculeGraphFromStructure((OakLeafSubstructure)((OakLeafSubstructure)fa5.get()));
        MoleculeBond consideredEdge = (MoleculeBond)phenylAlaninePattern.getEdge(7);
        BiFunction<MoleculeBond, MoleculeBond, Boolean> bondCondition = (patternBond, targetBond) -> {
            if (patternBond.equals((Object)consideredEdge)) {
                return patternBond.getType().equals((Object)targetBond.getType());
            }
            return true;
        };
        MoleculeIsomorphism moleculeIsomorphism = MoleculeIsomorphismFinder.of((MoleculeGraph)phenylAlaninePattern, (MoleculeGraph)fa5Graph, (BiFunction)MoleculeIsomorphismFinder.AtomConditions.isSameElement(), bondCondition);
        moleculeIsomorphism.reduceMatches();
        GraphDisplayApplication.renderer = new MoleculeGraphRenderer();
        GraphDisplayApplication.graph = fa5Graph;
        GraphDisplayApplication.renderer.setRenderAfter(graph -> {
            for (MoleculeAtom moleculeAtom : fa5Graph.getNodes()) {
                if (!((MoleculeGraph)moleculeIsomorphism.getFullMatches().get(0)).getNodes().contains(moleculeAtom)) continue;
                GraphDisplayApplication.renderer.getGraphicsContext().setStroke((Paint)Color.DARKRED);
                GraphDisplayApplication.renderer.circlePoint((Vector2D)moleculeAtom.getPosition(), 35.0);
            }
            return null;
        });
        Application.launch(GraphDisplayApplication.class, (String[])new String[0]);
    }
}

