/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.viewer;

import de.bioforscher.singa.structure.elements.Element;
import de.bioforscher.singa.structure.model.families.AminoAcidFamily;
import de.bioforscher.singa.structure.model.families.NucleotideFamily;
import de.bioforscher.singa.structure.model.families.StructuralFamily;
import javafx.scene.paint.Color;
import javafx.scene.paint.PhongMaterial;

public class MaterialProvider {
    public static final PhongMaterial CARBON = MaterialProvider.crateMaterialFromColor(Color.LIGHTGRAY);
    public static final PhongMaterial NITROGEN = MaterialProvider.crateMaterialFromColor(Color.CORNFLOWERBLUE);
    public static final PhongMaterial OXYGEN = MaterialProvider.crateMaterialFromColor(Color.INDIANRED);
    public static final PhongMaterial HYDROGEN = MaterialProvider.crateMaterialFromColor(Color.LIGHTSKYBLUE);
    public static final PhongMaterial OTHER_ELEMENT = MaterialProvider.crateMaterialFromColor(Color.GREEN);
    public static final PhongMaterial NUCLEOTIDE = NITROGEN;
    public static final PhongMaterial AMINOACID = OXYGEN;
    public static final PhongMaterial OTHER_TYPE = MaterialProvider.crateMaterialFromColor(Color.DARKOLIVEGREEN);

    public static PhongMaterial getDefaultMaterialForElement(Element element) {
        switch (element.getSymbol()) {
            case "C": {
                return CARBON;
            }
            case "N": {
                return NITROGEN;
            }
            case "O": {
                return OXYGEN;
            }
            case "H": {
                return HYDROGEN;
            }
        }
        return OTHER_ELEMENT;
    }

    public static PhongMaterial getMaterialForType(StructuralFamily structuralFamily) {
        if (structuralFamily instanceof NucleotideFamily) {
            return NUCLEOTIDE;
        }
        if (structuralFamily instanceof AminoAcidFamily) {
            return AMINOACID;
        }
        return OTHER_TYPE;
    }

    public static PhongMaterial crateMaterialFromColor(Color color) {
        PhongMaterial material = new PhongMaterial();
        material.setDiffuseColor(color.darker());
        material.setSpecularColor(color.brighter());
        return material;
    }
}

