/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.renderer.molecules;

import de.bioforscher.singa.javafx.renderer.graphs.GraphRenderOptions;
import de.bioforscher.singa.javafx.renderer.graphs.GraphRenderer;
import de.bioforscher.singa.javafx.renderer.molecules.MoleculeRendererOptions;
import de.bioforscher.singa.mathematics.geometry.edges.LineSegment;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import de.bioforscher.singa.structure.model.molecules.MoleculeAtom;
import de.bioforscher.singa.structure.model.molecules.MoleculeBond;
import de.bioforscher.singa.structure.model.molecules.MoleculeGraph;
import javafx.scene.paint.Paint;

public class MoleculeGraphRenderer
extends GraphRenderer<MoleculeAtom, MoleculeBond, Integer, MoleculeGraph> {
    private final MoleculeRendererOptions moleculeOptions = new MoleculeRendererOptions();

    public MoleculeGraphRenderer() {
        GraphRenderOptions options = new GraphRenderOptions();
        options.setNodeDiameter(22.0);
        this.setRenderingOptions(options);
    }

    @Override
    protected void drawNode(MoleculeAtom atom) {
        this.getGraphicsContext().setFill((Paint)this.moleculeOptions.getColorForElement(atom.getElement().getSymbol()));
        this.drawPoint((Vector2D)atom.getPosition(), this.getRenderingOptions().getNodeDiameter());
        this.getGraphicsContext().setStroke((Paint)this.getRenderingOptions().getEdgeColor());
        this.circlePoint((Vector2D)atom.getPosition(), this.getRenderingOptions().getNodeDiameter());
        this.getGraphicsContext().setFill((Paint)this.getRenderingOptions().getIdentifierTextColor());
        this.drawTextCenteredOnPoint(atom.getElement().toString() + "." + atom.getIdentifier(), (Vector2D)atom.getPosition());
    }

    @Override
    protected void drawEdge(MoleculeBond bond) {
        this.getGraphicsContext().setLineWidth(this.getRenderingOptions().getEdgeThickness());
        this.getGraphicsContext().setStroke((Paint)this.getRenderingOptions().getEdgeColor());
        this.drawBond(bond);
    }

    private void drawBond(MoleculeBond bond) {
        LineSegment connectingSegment = new LineSegment((Vector2D)((MoleculeAtom)bond.getSource()).getPosition(), (Vector2D)((MoleculeAtom)bond.getTarget()).getPosition());
        switch (bond.getType()) {
            case DOUBLE_BOND: {
                LineSegment upperParallelSegment = connectingSegment.getParallelSegment(this.getRenderingOptions().getNodeDiameter() / 2.0 * 0.5);
                this.drawLineSegment(upperParallelSegment);
                LineSegment lowerParallelSegment = connectingSegment.getParallelSegment(-this.getRenderingOptions().getNodeDiameter() / 2.0 * 0.5);
                this.drawLineSegment(lowerParallelSegment);
                break;
            }
            case AROMATIC_BOND: {
                LineSegment upperParallelSegment = connectingSegment.getParallelSegment(this.getRenderingOptions().getNodeDiameter() / 2.0 * 0.5);
                this.drawLineSegment(upperParallelSegment);
                LineSegment lowerParallelSegment = connectingSegment.getParallelSegment(-this.getRenderingOptions().getNodeDiameter() / 2.0 * 0.5);
                this.dashLineSegment(lowerParallelSegment, new double[]{2.0, 4.0});
                break;
            }
            default: {
                this.drawLineSegment(connectingSegment);
            }
        }
    }
}

