/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.renderer.graphs;

import de.bioforscher.singa.javafx.renderer.graphs.GraphRenderer;
import de.bioforscher.singa.mathematics.algorithms.voronoi.VoronoiRelaxation;
import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector2D;

public class RelaxationProducer<NodeType extends Node<NodeType, Vector2D, IdentifierType>, EdgeType extends Edge<NodeType>, IdentifierType, GraphType extends Graph<NodeType, EdgeType, IdentifierType>>
implements Runnable {
    private final GraphRenderer<NodeType, EdgeType, IdentifierType, GraphType> renderer;
    private GraphType graph;
    private int totalIterations;

    public RelaxationProducer(GraphRenderer<NodeType, EdgeType, IdentifierType, GraphType> renderer, GraphType graph, int totalIterations) {
        this.renderer = renderer;
        this.graph = graph;
        this.totalIterations = totalIterations;
    }

    @Override
    public void run() {
        Rectangle boundingBox = new Rectangle(this.renderer.drawingWidthProperty().doubleValue(), this.renderer.drawingHeightProperty().doubleValue());
        for (int i = 0; i < this.totalIterations; ++i) {
            this.renderer.getGraphQueue().add(VoronoiRelaxation.relax(this.graph, (Rectangle)boundingBox));
            try {
                Thread.sleep(40L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

