/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.renderer.graphs;

import de.bioforscher.singa.javafx.renderer.Renderer;
import de.bioforscher.singa.javafx.renderer.graphs.GraphDrawingTool;
import de.bioforscher.singa.javafx.renderer.graphs.GraphProducer;
import de.bioforscher.singa.javafx.renderer.graphs.GraphRenderOptions;
import de.bioforscher.singa.javafx.renderer.graphs.RelaxationProducer;
import de.bioforscher.singa.mathematics.algorithms.voronoi.VoronoiGenerator;
import de.bioforscher.singa.mathematics.algorithms.voronoi.VoronoiRelaxation;
import de.bioforscher.singa.mathematics.algorithms.voronoi.model.VoronoiDiagram;
import de.bioforscher.singa.mathematics.geometry.edges.LineSegment;
import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class GraphRenderer<NodeType extends Node<NodeType, Vector2D, IdentifierType>, EdgeType extends Edge<NodeType>, IdentifierType, GraphType extends Graph<NodeType, EdgeType, IdentifierType>>
extends AnimationTimer
implements Renderer {
    private final ConcurrentLinkedQueue<GraphType> graphQueue = new ConcurrentLinkedQueue();
    private GraphRenderOptions renderingOptions = new GraphRenderOptions();
    private Function<GraphType, Void> renderBeforeFunction;
    private Function<GraphType, Void> renderAfterFunction;
    private GraphicsContext graphicsContext;
    private final DoubleProperty drawingWidth = new SimpleDoubleProperty();
    private final DoubleProperty drawingHeight = new SimpleDoubleProperty();
    private StringProperty renderingMode = new SimpleStringProperty(RenderingMode.FORCE_DIRECTED.name());

    public void arrangeGraph(GraphType graph) {
        Thread graphProducer = new Thread(new GraphProducer(this, graph, 100));
        graphProducer.start();
        this.start();
    }

    public void arrangeOnce(GraphType graph) {
        GraphDrawingTool gdt = new GraphDrawingTool(graph, this.drawingWidthProperty(), this.drawingHeightProperty(), 100);
        this.render(gdt.arrangeGraph(80));
    }

    public void relaxGraph(GraphType graph) {
        Thread graphProducer = new Thread(new RelaxationProducer(this, graph, 100));
        graphProducer.start();
        this.start();
    }

    public void relaxOnce(GraphType graph) {
        Rectangle boundingBox = new Rectangle(this.drawingWidthProperty().doubleValue(), this.drawingHeightProperty().doubleValue());
        this.render(VoronoiRelaxation.relax(graph, (Rectangle)boundingBox));
    }

    public void handle(long now) {
        Graph graph;
        while ((graph = (Graph)this.graphQueue.poll()) != null) {
            this.render(graph);
        }
    }

    public void render(GraphType graph) {
        this.fillBackground();
        if (this.renderBeforeFunction != null) {
            this.renderBeforeFunction.apply(graph);
        }
        if (this.renderingOptions.isDisplayingEdges()) {
            graph.getEdges().forEach(this::drawEdge);
        }
        if (this.renderingOptions.isDisplayingNodes()) {
            graph.getNodes().forEach(this::drawNode);
        }
        if (this.renderAfterFunction != null) {
            this.renderAfterFunction.apply(graph);
        }
    }

    public void fillBackground() {
        this.getGraphicsContext().setFill((Paint)this.renderingOptions.getBackgroundColor());
        this.getGraphicsContext().fillRect(0.0, 0.0, this.getDrawingWidth(), this.getDrawingHeight());
    }

    public void setRenderAfter(Function<GraphType, Void> renderAfterFunction) {
        this.renderAfterFunction = renderAfterFunction;
    }

    public void setRenderBefore(Function<GraphType, Void> renderBeforeFunction) {
        this.renderBeforeFunction = renderBeforeFunction;
    }

    protected void drawNode(NodeType node) {
        this.getGraphicsContext().setFill((Paint)this.renderingOptions.getNodeColor());
        this.drawPoint((Vector2D)node.getPosition(), this.renderingOptions.getNodeDiameter());
        this.getGraphicsContext().setFill((Paint)this.renderingOptions.getIdentifierTextColor());
        this.drawTextCenteredOnPoint(String.valueOf(node.getIdentifier()), (Vector2D)node.getPosition());
    }

    public ConcurrentLinkedQueue<GraphType> getGraphQueue() {
        return this.graphQueue;
    }

    protected void drawEdge(EdgeType edge) {
        this.getGraphicsContext().setLineWidth(this.renderingOptions.getEdgeThickness());
        this.getGraphicsContext().setStroke((Paint)this.renderingOptions.getEdgeColor());
        this.drawLineSegment(new LineSegment((Vector2D)edge.getSource().getPosition(), (Vector2D)edge.getTarget().getPosition()));
    }

    public void renderVoronoi(boolean flag) {
        this.renderBeforeFunction = flag ? graph -> {
            List sites = graph.getNodes().stream().map(Node::getPosition).collect(Collectors.toList());
            VoronoiDiagram voronoiDiagram = VoronoiGenerator.generateVoronoiDiagram(sites, (Rectangle)new Rectangle(this.drawingWidth.doubleValue(), this.drawingHeight.doubleValue()));
            this.drawDiagram(voronoiDiagram);
            return null;
        } : null;
    }

    public void drawDiagram(VoronoiDiagram diagram) {
        this.getGraphicsContext().setStroke((Paint)Color.SEAGREEN);
        this.getGraphicsContext().setLineWidth(4.0);
        diagram.getEdges().forEach(edge -> this.drawStraight(edge.getStartingPoint(), edge.getEndingPoint()));
        this.getGraphicsContext().setLineWidth(6.0);
        this.getGraphicsContext().setFill((Paint)Color.SEAGREEN.darker());
        diagram.getVertices().forEach(this::drawPoint);
    }

    public DoubleProperty drawingWidthProperty() {
        return this.drawingWidth;
    }

    public DoubleProperty drawingHeightProperty() {
        return this.drawingHeight;
    }

    @Override
    public GraphicsContext getGraphicsContext() {
        return this.graphicsContext;
    }

    public void setGraphicsContext(GraphicsContext graphicsContext) {
        this.graphicsContext = graphicsContext;
    }

    @Override
    public double getDrawingWidth() {
        return this.drawingWidth.get();
    }

    @Override
    public double getDrawingHeight() {
        return this.drawingHeight.get();
    }

    public GraphRenderOptions getRenderingOptions() {
        return this.renderingOptions;
    }

    public void setRenderingOptions(GraphRenderOptions renderingOptions) {
        this.renderingOptions = renderingOptions;
    }

    public String getRenderingMode() {
        return (String)this.renderingMode.get();
    }

    public StringProperty renderingModeProperty() {
        return this.renderingMode;
    }

    public void setRenderingMode(String renderingMode) {
        this.renderingMode.set((Object)renderingMode);
    }

    public static enum RenderingMode {
        FORCE_DIRECTED("Force directed"),
        LLOYDS_RELAXATION("Lloyd's relaxation");

        private final String dispayText;

        private RenderingMode(String dispayText) {
            this.dispayText = dispayText;
        }

        public String getDispayText() {
            return this.dispayText;
        }
    }
}

