/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.renderer.graphs;

import de.bioforscher.singa.javafx.renderer.graphs.GraphCanvas;
import de.bioforscher.singa.javafx.renderer.graphs.GraphRenderer;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.mathematics.graphs.model.Graphs;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import javafx.application.Application;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class GraphDisplayApplication
extends Application {
    public static Graph<? extends de.bioforscher.singa.mathematics.graphs.model.Node<?, Vector2D, ?>, ?, ?> graph = Graphs.buildGridGraph((int)5, (int)5);
    public static GraphRenderer renderer = new GraphRenderer();

    public static void main(String[] args) {
        GraphDisplayApplication.launch((String[])new String[0]);
    }

    public void start(Stage primaryStage) {
        BorderPane root = new BorderPane();
        VBox topContainer = new VBox();
        MenuBar menuBar = this.prepareMenus();
        ToolBar toolBar = this.prepareViewingToolBar();
        topContainer.getChildren().addAll((Object[])new Node[]{menuBar, toolBar});
        root.setTop((Node)topContainer);
        GraphCanvas canvas = new GraphCanvas();
        renderer.renderVoronoi(false);
        root.setCenter((Node)canvas);
        Scene scene = new Scene((Parent)root);
        primaryStage.setScene(scene);
        primaryStage.show();
        renderer.drawingWidthProperty().bind((ObservableValue)canvas.widthProperty());
        renderer.drawingHeightProperty().bind((ObservableValue)canvas.heightProperty());
        renderer.setGraphicsContext(canvas.getGraphicsContext2D());
        canvas.widthProperty().bind((ObservableValue)root.widthProperty());
        canvas.heightProperty().bind((ObservableValue)root.heightProperty().subtract((ObservableNumberValue)topContainer.heightProperty()));
        canvas.widthProperty().addListener(observable -> renderer.render(graph));
        canvas.heightProperty().addListener(observable -> renderer.render(graph));
    }

    private ToolBar prepareViewingToolBar() {
        ToolBar toolBar = new ToolBar();
        Button forceDirectedLayout = new Button("Arrange");
        forceDirectedLayout.setOnAction(action -> renderer.arrangeGraph(graph));
        Button relaxLayout = new Button("Relax");
        relaxLayout.setOnAction(action -> renderer.relaxGraph(graph));
        toolBar.getItems().addAll((Object[])new Node[]{forceDirectedLayout, relaxLayout});
        return toolBar;
    }

    private MenuBar prepareMenus() {
        MenuBar menuBar = new MenuBar();
        Menu menuFile = new Menu("File");
        MenuItem mINewGraph = new MenuItem("New graph ...");
        mINewGraph.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.G, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        MenuItem mILoadBioGraph = new MenuItem("Open graph ...");
        mILoadBioGraph.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        MenuItem mISaveGraph = new MenuItem("Save graph ...");
        mISaveGraph.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        Menu menuRendering = new Menu("Rendering");
        Menu menuRenderingMode = new Menu("Rendering mode");
        ToggleGroup groupRenderingMode = new ToggleGroup();
        for (GraphRenderer.RenderingMode renderingMode : GraphRenderer.RenderingMode.values()) {
            RadioMenuItem itemMode = new RadioMenuItem(renderingMode.getDispayText());
            itemMode.setUserData((Object)renderingMode);
            itemMode.setToggleGroup(groupRenderingMode);
            menuRenderingMode.getItems().add((Object)itemMode);
            if (!renderingMode.name().equals(renderer.getRenderingMode())) continue;
            itemMode.setSelected(true);
        }
        groupRenderingMode.selectedToggleProperty().addListener((ov, old_toggle, new_toggle) -> {
            if (groupRenderingMode.getSelectedToggle() != null) {
                renderer.setRenderingMode(((GraphRenderer.RenderingMode)((Object)((Object)groupRenderingMode.getSelectedToggle().getUserData()))).name());
            }
        });
        CheckMenuItem voronoiItem = new CheckMenuItem("Render Voronoi");
        voronoiItem.setSelected(true);
        voronoiItem.selectedProperty().addListener((ov, old_val, new_val) -> {
            renderer.renderVoronoi((boolean)new_val);
            renderer.render(graph);
        });
        menuRendering.getItems().addAll((Object[])new MenuItem[]{menuRenderingMode, voronoiItem});
        menuFile.getItems().addAll((Object[])new MenuItem[]{mINewGraph, mILoadBioGraph, mISaveGraph});
        menuBar.getMenus().addAll((Object[])new Menu[]{menuFile, menuRendering});
        return menuBar;
    }

    public static GraphRenderer getRenderer() {
        return renderer;
    }

    public static Graph<? extends de.bioforscher.singa.mathematics.graphs.model.Node<?, Vector2D, ?>, ?, ?> getGraph() {
        return graph;
    }
}

