/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.renderer;

import de.bioforscher.singa.javafx.renderer.Renderer;
import de.bioforscher.singa.mathematics.geometry.edges.Line;
import de.bioforscher.singa.mathematics.geometry.edges.Parabola;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class RendererExamples
extends Application
implements Renderer {
    private Canvas canvas;

    public static void main(String[] args) {
        RendererExamples.launch((String[])new String[0]);
    }

    public void start(Stage primaryStage) {
        this.canvas = new Canvas(500.0, 500.0);
        BorderPane root = new BorderPane();
        root.setCenter((Node)this.canvas);
        this.getGraphicsContext().setLineWidth(5.0);
        this.getGraphicsContext().setStroke((Paint)Color.BLACK);
        Line xAxis = new Line(0.0, 0.0);
        Line yAxis = new Line(0.0, Double.POSITIVE_INFINITY);
        this.drawLine(xAxis);
        this.drawLine(yAxis);
        this.getGraphicsContext().setStroke((Paint)Color.INDIANRED);
        Vector2D focus = new Vector2D(150.0, 70.0);
        this.drawPoint(focus);
        this.getGraphicsContext().setLineWidth(2.0);
        this.getGraphicsContext().setFill((Paint)Color.CORAL);
        Line directrix = new Line(50.0, 0.0);
        this.drawLine(directrix);
        Parabola parabola = new Parabola(focus, directrix);
        this.drawParabola(parabola, 30);
        Line randomLine = new Line(new Vector2D(140.0, 60.0), Double.POSITIVE_INFINITY);
        this.getGraphicsContext().setStroke((Paint)Color.DARKGOLDENROD);
        this.drawLine(randomLine);
        this.getGraphicsContext().setLineWidth(5.0);
        this.getGraphicsContext().setFill((Paint)Color.BROWN);
        parabola.getIntercepts(randomLine).forEach(this::drawPoint);
        Scene scene = new Scene((Parent)root);
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    @Override
    public GraphicsContext getGraphicsContext() {
        return this.canvas.getGraphicsContext2D();
    }

    @Override
    public double getDrawingWidth() {
        return this.canvas.getWidth();
    }

    @Override
    public double getDrawingHeight() {
        return this.canvas.getHeight();
    }
}

