/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.renderer.graphs;

import de.bioforscher.singa.javafx.renderer.graphs.GraphCanvas;
import de.bioforscher.singa.javafx.renderer.graphs.GraphRenderer;
import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.mathematics.graphs.model.Graphs;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import javafx.application.Application;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

public class GraphDisplayApplication
extends Application {
    public static Graph<? extends de.bioforscher.singa.mathematics.graphs.model.Node<?, Vector2D, ?>, ?, ?> graph = Graphs.buildTreeGraph((int)10, (Rectangle)new Rectangle(500.0, 500.0));
    public static GraphRenderer renderer = new GraphRenderer();

    public static void main(String[] args) {
        GraphDisplayApplication.launch((String[])new String[0]);
    }

    public void start(Stage primaryStage) throws Exception {
        GraphCanvas canvas = new GraphCanvas(this);
        BorderPane root = new BorderPane();
        root.setCenter((Node)canvas);
        HBox buttonBar = new HBox();
        Button forceDirectedLayout = new Button("Arrange");
        forceDirectedLayout.setOnAction(action -> renderer.arrangeGraph(graph));
        Button relaxLayout = new Button("Relax");
        relaxLayout.setOnAction(action -> renderer.relaxGraph(graph));
        buttonBar.getChildren().addAll((Object[])new Node[]{forceDirectedLayout, relaxLayout});
        root.setBottom((Node)buttonBar);
        Scene scene = new Scene((Parent)root);
        primaryStage.setScene(scene);
        primaryStage.show();
        renderer.drawingWidthProperty().bind((ObservableValue)canvas.widthProperty());
        renderer.drawingHeightProperty().bind((ObservableValue)canvas.heightProperty());
        renderer.setGraphicsContext(canvas.getGraphicsContext2D());
        canvas.widthProperty().bind((ObservableValue)root.widthProperty());
        canvas.heightProperty().bind((ObservableValue)root.heightProperty().subtract((ObservableNumberValue)buttonBar.heightProperty()));
        canvas.widthProperty().addListener(observable -> renderer.render(graph));
        canvas.heightProperty().addListener(observable -> renderer.render(graph));
    }

    public void triggerRendering() {
        renderer.render(graph);
    }

    public static GraphRenderer getRenderer() {
        return renderer;
    }

    public static Graph<? extends de.bioforscher.singa.mathematics.graphs.model.Node<?, Vector2D, ?>, ?, ?> getGraph() {
        return graph;
    }
}

