/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.renderer.graphs;

import de.bioforscher.singa.javafx.renderer.graphs.GraphDisplayApplication;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import java.util.Iterator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.canvas.Canvas;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class GraphCanvas
extends Canvas {
    private GraphDisplayApplication owner;
    private BooleanProperty editMode;
    private Vector2D dragStart;
    private Node<?, Vector2D, ?> draggedNode;

    public GraphCanvas(GraphDisplayApplication owner) {
        this.owner = owner;
        this.editMode = new SimpleBooleanProperty(true);
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, this::handleClick);
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, this::handleDrag);
        this.addEventHandler(MouseEvent.MOUSE_DRAGGED, this::handleDrag);
        this.addEventHandler(MouseEvent.MOUSE_RELEASED, this::handleDrag);
    }

    private void handleDrag(MouseEvent event) {
        if (event.getButton().equals((Object)MouseButton.PRIMARY)) {
            if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
                this.dragStart = new Vector2D(event.getX(), event.getY());
                for (Node node : GraphDisplayApplication.getGraph().getNodes()) {
                    if (!this.isClickedOnNode(event, node)) continue;
                    this.draggedNode = node;
                    break;
                }
            } else if (event.getEventType() == MouseEvent.MOUSE_DRAGGED) {
                if (this.draggedNode != null) {
                    this.draggedNode.setPosition((Vector)new Vector2D(event.getX(), event.getY()));
                }
                this.owner.triggerRendering();
            } else if (event.getEventType() == MouseEvent.MOUSE_RELEASED) {
                this.draggedNode = null;
                this.owner.triggerRendering();
            }
        }
    }

    private void handleClick(MouseEvent event) {
        if (event.getButton().equals((Object)MouseButton.SECONDARY)) {
            this.handleRightClick(event);
        } else if (event.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.handleLeftClick(event);
        }
    }

    private void handleRightClick(MouseEvent event) {
        boolean isNode = false;
        for (Node node : GraphDisplayApplication.getGraph().getNodes()) {
            if (!this.isClickedOnNode(event, node)) continue;
            isNode = true;
            break;
        }
        if (!isNode) {
            // empty if block
        }
    }

    private void handleLeftClick(MouseEvent event) {
        Node node;
        Iterator iterator = GraphDisplayApplication.getGraph().getNodes().iterator();
        while (iterator.hasNext() && !this.isClickedOnNode(event, node = (Node)iterator.next())) {
        }
    }

    private boolean isClickedOnNode(MouseEvent event, Node<?, Vector2D, ?> node) {
        return ((Vector2D)node.getPosition()).isNearVector(new Vector2D(event.getX() + GraphDisplayApplication.getRenderer().getRenderingOptions().getNodeDiameter() / 2.0, event.getY() + GraphDisplayApplication.getRenderer().getRenderingOptions().getNodeDiameter() / 2.0), GraphDisplayApplication.getRenderer().getRenderingOptions().getNodeDiameter() / 2.0);
    }

    public boolean isResizable() {
        return true;
    }
}

