/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.renderer;

import de.bioforscher.singa.mathematics.geometry.edges.Line;
import de.bioforscher.singa.mathematics.geometry.edges.LineSegment;
import de.bioforscher.singa.mathematics.geometry.edges.Parabola;
import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.geometry.model.Polygon;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.text.TextAlignment;

public interface Renderer {
    public GraphicsContext getGraphicsContext();

    public double getDrawingWidth();

    public double getDrawingHeight();

    default public void drawPoint(Vector2D point, double diameter) {
        this.getGraphicsContext().fillOval(point.getX() - diameter / 2.0, point.getY() - diameter / 2.0, diameter, diameter);
    }

    default public void drawPoint(Vector2D point) {
        this.drawPoint(point, this.getGraphicsContext().getLineWidth());
    }

    default public void circlePoint(Vector2D point, double diameter) {
        this.getGraphicsContext().strokeOval(point.getX() - diameter / 2.0, point.getY() - diameter / 2.0, diameter, diameter);
    }

    default public void connectPoints(Collection<Vector2D> vectors) {
        this.getGraphicsContext().strokePolyline(vectors.stream().mapToDouble(Vector2D::getX).toArray(), vectors.stream().mapToDouble(Vector2D::getY).toArray(), vectors.size());
    }

    default public void drawStraight(Vector2D start, Vector2D end) {
        this.getGraphicsContext().strokeLine(start.getX(), start.getY(), end.getX(), end.getY());
    }

    default public void drawLineSegment(LineSegment lineSegment) {
        this.drawStraight(lineSegment.getStartingPoint(), lineSegment.getEndingPoint());
    }

    default public void dashLineSegment(LineSegment lineSegment, double ... dashes) {
        this.getGraphicsContext().setLineDashes(dashes);
        this.drawStraight(lineSegment.getStartingPoint(), lineSegment.getEndingPoint());
        this.getGraphicsContext().setLineDashes(null);
    }

    default public void drawLine(Line line) {
        Vector2D end;
        Vector2D start;
        double minX = 0.0;
        double maxX = this.getDrawingWidth();
        double minY = 0.0;
        double maxY = this.getDrawingHeight();
        if (line.isHorizontal()) {
            start = new Vector2D(0.0, line.getYIntercept());
            end = new Vector2D(maxX, line.getYIntercept());
        } else if (line.isVertical()) {
            start = new Vector2D(line.getXIntercept(), 0.0);
            end = new Vector2D(line.getXIntercept(), maxY);
        } else {
            start = line.getInterceptWithLine(new Line(0.0, 0.0));
            end = line.getInterceptWithLine(new Line(maxY, 0.0));
        }
        this.drawStraight(start, end);
    }

    default public void drawParabola(Parabola parabola) {
        this.drawParabola(parabola, 20);
    }

    default public void drawParabola(Parabola parabola, int samplingDepth) {
        Vector2D rightMost;
        Vector2D leftMost;
        SortedSet xIntercepts;
        double minX = 0.0;
        double maxX = this.getDrawingWidth();
        double maxY = this.getDrawingHeight();
        ArrayList<Vector2D> list = new ArrayList<Vector2D>();
        if (!parabola.isOpenTowardsXAxis()) {
            xIntercepts = parabola.getIntercepts(new Line(maxY, 0.0));
            leftMost = ((Vector2D)xIntercepts.first()).getX() < 0.0 ? new Vector2D(0.0, parabola.getYValue(0.0)) : (Vector2D)xIntercepts.first();
            list.add(leftMost);
            rightMost = ((Vector2D)xIntercepts.last()).getX() > maxX ? new Vector2D(maxX, parabola.getYValue(maxX)) : (Vector2D)xIntercepts.last();
            list.add(rightMost);
        } else {
            xIntercepts = parabola.getXIntercepts();
            leftMost = (Double)xIntercepts.first() < 0.0 ? new Vector2D(0.0, parabola.getYValue(0.0)) : new Vector2D(((Double)xIntercepts.first()).doubleValue(), 0.0);
            list.add(leftMost);
            rightMost = (Double)xIntercepts.last() > maxX ? new Vector2D(maxX, parabola.getYValue(maxX)) : new Vector2D(((Double)xIntercepts.last()).doubleValue(), 0.0);
            list.add(rightMost);
        }
        double maximalExtend = leftMost.distanceTo((Vector)rightMost);
        double offset = maximalExtend / (double)samplingDepth;
        for (double currentX = leftMost.getX() + offset; currentX < rightMost.getX(); currentX += offset) {
            list.add(new Vector2D(currentX, parabola.getYValue(currentX)));
        }
        list.sort(Comparator.comparing(Vector2D::getX));
        this.connectPoints(list);
    }

    default public void drawTextCenteredOnPoint(String text, Vector2D center) {
        TextAlignment initialTextAlign = this.getGraphicsContext().getTextAlign();
        this.getGraphicsContext().setTextAlign(TextAlignment.CENTER);
        this.getGraphicsContext().fillText(text, center.getX(), center.getY());
        this.getGraphicsContext().setTextAlign(initialTextAlign);
    }

    default public void drawRectangle(Vector2D topLeftCorner, Vector2D bottomRightCorner) {
        Rectangle rectangle = new Rectangle(topLeftCorner, bottomRightCorner);
        this.getGraphicsContext().fillRect(topLeftCorner.getX(), topLeftCorner.getY(), rectangle.getHeight(), rectangle.getWidth());
    }

    default public Rectangle drawDraggedRectangle(Vector2D firstCorner, Vector2D secondCorner) {
        Rectangle rectangle = firstCorner.isLeftOf(secondCorner) && firstCorner.isAbove(secondCorner) ? new Rectangle(firstCorner, secondCorner) : (firstCorner.isLeftOf(secondCorner) && firstCorner.isBelow(secondCorner) ? new Rectangle(new Vector2D(firstCorner.getX(), secondCorner.getY()), new Vector2D(secondCorner.getX(), firstCorner.getY())) : (firstCorner.isRightOf(secondCorner) && firstCorner.isAbove(secondCorner) ? new Rectangle(new Vector2D(secondCorner.getX(), firstCorner.getY()), new Vector2D(firstCorner.getX(), secondCorner.getY())) : new Rectangle(secondCorner, firstCorner)));
        this.getGraphicsContext().fillRect(rectangle.getTopLeftVertex().getX(), rectangle.getTopLeftVertex().getY(), rectangle.getHeight(), rectangle.getWidth());
        return rectangle;
    }

    default public void fillPolygon(Polygon polygon) {
        int numberOfVertices = polygon.getNumberOfVertices();
        double[] xPositions = new double[polygon.getNumberOfVertices()];
        double[] yPositions = new double[polygon.getNumberOfVertices()];
        Vector2D[] vertices = (Vector2D[])polygon.getVertices();
        for (int index = 0; index < vertices.length; ++index) {
            Vector2D vertex = vertices[index];
            xPositions[index] = vertex.getX();
            yPositions[index] = vertex.getY();
        }
        this.getGraphicsContext().fillPolygon(xPositions, yPositions, numberOfVertices);
    }
}

