/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.renderer.graphs;

import de.bioforscher.singa.javafx.renderer.graphs.GraphDrawingTool;
import de.bioforscher.singa.javafx.renderer.graphs.GraphRenderer;
import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector2D;

public class GraphProducer<NodeType extends Node<NodeType, Vector2D, IdentifierType>, EdgeType extends Edge<NodeType>, IdentifierType, GraphType extends Graph<NodeType, EdgeType, IdentifierType>>
implements Runnable {
    private final GraphRenderer<NodeType, EdgeType, IdentifierType, GraphType> renderer;
    private GraphType graph;
    private int totalIterations;

    public GraphProducer(GraphRenderer<NodeType, EdgeType, IdentifierType, GraphType> renderer, GraphType graph, int iterations) {
        this.renderer = renderer;
        this.graph = graph;
        this.totalIterations = iterations;
    }

    @Override
    public void run() {
        GraphDrawingTool gdt = new GraphDrawingTool(this.graph, this.renderer.drawingWidthProperty(), this.renderer.drawingHeightProperty(), 100);
        for (int i = 0; i < this.totalIterations; ++i) {
            this.renderer.getGraphQueue().add(gdt.arrangeGraph(i));
            try {
                Thread.sleep(40L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

