/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.renderer.graphs;

import de.bioforscher.singa.mathematics.forces.AttractiveForce;
import de.bioforscher.singa.mathematics.forces.Force;
import de.bioforscher.singa.mathematics.forces.RepulsiveForce;
import de.bioforscher.singa.mathematics.functions.DecayFunctions;
import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import java.util.HashMap;
import javafx.beans.property.DoubleProperty;

public class GraphDrawingTool<NodeType extends Node<NodeType, Vector2D, IdentifierType>, EdgeType extends Edge<NodeType>, IdentifierType, GraphType extends Graph<NodeType, EdgeType, IdentifierType>> {
    private DoubleProperty drawingWidth;
    private DoubleProperty drawingHeight;
    private final int totalIterations;
    private Force repulsiveForce;
    private Force attractiveForce;
    private Force boundaryForce;
    private GraphType graph;
    private HashMap<NodeType, Vector2D> velocities;

    public GraphDrawingTool(GraphType graph, DoubleProperty drawingWidth, DoubleProperty drawingHeight, int totalIterations) {
        this.drawingWidth = drawingWidth;
        this.drawingHeight = drawingHeight;
        this.totalIterations = totalIterations;
        this.graph = graph;
        double forceConstant = Math.sqrt(drawingHeight.get() * drawingWidth.get() / (double)(graph.getNodes().size() * 20));
        this.repulsiveForce = new RepulsiveForce(forceConstant);
        this.boundaryForce = new RepulsiveForce(forceConstant * 2.0);
        this.attractiveForce = new AttractiveForce(forceConstant);
        this.velocities = new HashMap();
        for (Node n : graph.getNodes()) {
            this.velocities.put(n, new Vector2D(0.0, 0.0));
        }
    }

    public GraphType arrangeGraph(int i) {
        Vector2D acceleration;
        double t = DecayFunctions.linear((int)i, (int)this.totalIterations, (double)(this.drawingWidth.doubleValue() / 40.0));
        for (Node sourceNode : this.graph.getNodes()) {
            this.velocities.put(sourceNode, new Vector2D());
            for (Node targetNode : this.graph.getNodes()) {
                if (sourceNode.equals(targetNode)) continue;
                acceleration = this.repulsiveForce.calculateAcceleration((Vector2D)sourceNode.getPosition(), (Vector2D)targetNode.getPosition());
                Vector2D velocity = this.velocities.get(sourceNode).add(acceleration);
                this.velocities.put(sourceNode, velocity);
            }
        }
        for (Edge edge : this.graph.getEdges()) {
            Node targetNode;
            Node sourceNode = edge.getSource();
            targetNode = edge.getTarget();
            acceleration = this.attractiveForce.calculateAcceleration((Vector2D)sourceNode.getPosition(), (Vector2D)targetNode.getPosition());
            Vector2D velocityTarget = this.velocities.get(targetNode).add(acceleration);
            this.velocities.put(targetNode, velocityTarget);
            Vector2D velocitySource = this.velocities.get(sourceNode).subtract(acceleration);
            this.velocities.put(sourceNode, velocitySource);
        }
        for (Node node : this.graph.getNodes()) {
            Vector2D position = (Vector2D)node.getPosition();
            double barrierRadius = this.drawingWidth.doubleValue() / 4.0;
            Vector2D accelerationX = position.getX() < barrierRadius ? this.boundaryForce.calculateAcceleration(position, new Vector2D(0.0, position.getY())) : (position.getX() > this.drawingWidth.doubleValue() - barrierRadius ? this.boundaryForce.calculateAcceleration(position, new Vector2D(this.drawingWidth.doubleValue(), position.getY())) : new Vector2D(0.0, 0.0));
            Vector2D accelerationY = position.getY() < barrierRadius ? this.boundaryForce.calculateAcceleration(position, new Vector2D(position.getX(), 0.0)) : (position.getY() > this.drawingHeight.doubleValue() - barrierRadius ? this.boundaryForce.calculateAcceleration(position, new Vector2D(position.getX(), this.drawingHeight.doubleValue())) : new Vector2D(0.0, 0.0));
            Vector2D totalAcceleration = accelerationX.add(accelerationY);
            Vector2D velocitySource = this.velocities.get(node).add(totalAcceleration);
            this.velocities.put(node, velocitySource);
        }
        for (Node node : this.graph.getNodes()) {
            Vector2D currentLocation = (Vector2D)node.getPosition();
            Vector2D currentVelocity = this.velocities.get(node);
            double magnitude = currentVelocity.getMagnitude();
            Vector2D nextLocation = currentLocation.add(currentVelocity.normalize().multiply(Math.min(magnitude, t)));
            double nextX = nextLocation.getX() < this.drawingWidth.doubleValue() && nextLocation.getX() > 0.0 ? nextLocation.getX() : this.drawingWidth.doubleValue() / 2.0;
            double nextY = nextLocation.getY() < this.drawingHeight.doubleValue() && nextLocation.getY() > 0.0 ? nextLocation.getY() : this.drawingHeight.doubleValue() / 2.0;
            node.setPosition((Vector)new Vector2D(nextX, nextY));
        }
        return this.graph;
    }
}

