/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.geometry;

import de.bioforscher.singa.javafx.renderer.Renderer;
import de.bioforscher.singa.mathematics.algorithms.geometry.ConvexHull;
import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.vectors.Vectors;
import java.util.Collection;
import java.util.List;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class ConvexHullPlayground
extends Application
implements Renderer {
    private Canvas canvas;

    public static void main(String[] args) {
        ConvexHullPlayground.launch((String[])new String[0]);
    }

    public void init() throws Exception {
        this.canvas = new Canvas(500.0, 500.0);
    }

    public void start(Stage primaryStage) throws Exception {
        BorderPane root = new BorderPane();
        root.setCenter((Node)this.canvas);
        this.canvas.getGraphicsContext2D().setLineWidth(7.0);
        List vectors = Vectors.generateMultipleRandom2DVectors((int)20, (Rectangle)new Rectangle(500.0, 500.0));
        ConvexHull convexHull = ConvexHull.calculateHullFor((Collection)vectors);
        this.canvas.getGraphicsContext2D().setFill((Paint)Color.DIMGRAY);
        convexHull.getNonHullVectors().forEach(this::drawPoint);
        this.canvas.getGraphicsContext2D().setFill((Paint)Color.CORNFLOWERBLUE);
        convexHull.getHull().forEach(this::drawPoint);
        this.canvas.getGraphicsContext2D().setStroke((Paint)Color.CORNFLOWERBLUE);
        this.canvas.getGraphicsContext2D().setLineWidth(2.0);
        this.connectPoints(convexHull.getHull());
        Scene scene = new Scene((Parent)root);
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    @Override
    public GraphicsContext getGraphicsContext() {
        return this.canvas.getGraphicsContext2D();
    }

    @Override
    public double getDrawingWidth() {
        return this.canvas.getWidth();
    }

    @Override
    public double getDrawingHeight() {
        return this.canvas.getHeight();
    }
}

