/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.renderer.graphs;

import de.bioforscher.singa.chemistry.parser.pdb.structures.StructureParser;
import de.bioforscher.singa.chemistry.parser.pdb.structures.StructureSelector;
import de.bioforscher.singa.chemistry.parser.plip.InteractionContainer;
import de.bioforscher.singa.chemistry.parser.plip.PlipParser;
import de.bioforscher.singa.chemistry.parser.plip.PlipShellGenerator;
import de.bioforscher.singa.chemistry.physical.branches.Chain;
import de.bioforscher.singa.chemistry.physical.leaves.AtomContainer;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.Structure;
import de.bioforscher.singa.core.utility.Resources;
import de.bioforscher.singa.javafx.renderer.graphs.GraphDisplayApplication;
import de.bioforscher.singa.javafx.renderer.graphs.LeafShellRenderer;
import de.bioforscher.singa.mathematics.algorithms.graphs.NeighbourhoodExtractor;
import de.bioforscher.singa.mathematics.graphs.model.GenericGraph;
import de.bioforscher.singa.mathematics.graphs.model.GenericNode;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import java.io.InputStream;
import java.util.List;
import javafx.application.Application;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class GraphViewerPlayground {
    public static void main(String[] args) {
        Structure structure = StructureParser.online().pdbIdentifier("1c0a").parse();
        Chain chain = structure.getFirstChain();
        AtomContainer reference = StructureSelector.selectFrom((Chain)chain).atomContainer(831).selectAtomContainer();
        InteractionContainer interInteractions = PlipParser.parse((String)"1c0a", (InputStream)Resources.getResourceAsStream((String)"1c0a.xml"));
        InteractionContainer ligandInteractions = PlipParser.parse((String)"1c0a", (InputStream)Resources.getResourceAsStream((String)"1c0a_ligand.xml"));
        PlipShellGenerator plipShellGenerator = PlipShellGenerator.getInteractionShellsForLigand((Chain)chain, (LeafSubstructure)reference, (InteractionContainer)interInteractions, (InteractionContainer)ligandInteractions);
        GenericGraph graph = plipShellGenerator.getGraph();
        GenericNode referenceNode = (GenericNode)graph.getNodeWithContent((Object)reference).get();
        GenericGraph subgraph = (GenericGraph)NeighbourhoodExtractor.extractNeighborhood((Graph)graph, (Node)referenceNode, (int)3);
        List firstShell = NeighbourhoodExtractor.extractShell((Graph)graph, (Node)referenceNode, (int)1);
        List secondShell = NeighbourhoodExtractor.extractShell((Graph)graph, (Node)referenceNode, (int)2);
        List thirdShell = NeighbourhoodExtractor.extractShell((Graph)graph, (Node)referenceNode, (int)3);
        GraphDisplayApplication.graph = subgraph;
        LeafShellRenderer renderer = new LeafShellRenderer();
        GraphDisplayApplication.renderer = renderer;
        renderer.setRenderBefore(currentGraph -> {
            renderer.getGraphicsContext().setStroke((Paint)Color.DARKBLUE);
            for (GenericNode shellNode : firstShell) {
                renderer.circlePoint((Vector2D)((GenericNode)currentGraph.getNode(shellNode.getIdentifier())).getPosition(), renderer.getRenderingOptions().getNodeDiameter() + 2.0);
            }
            renderer.getGraphicsContext().setStroke((Paint)Color.RED);
            for (GenericNode shellNode : secondShell) {
                renderer.circlePoint((Vector2D)((GenericNode)currentGraph.getNode(shellNode.getIdentifier())).getPosition(), renderer.getRenderingOptions().getNodeDiameter() + 2.0);
            }
            renderer.getGraphicsContext().setStroke((Paint)Color.YELLOW);
            for (GenericNode shellNode : thirdShell) {
                renderer.circlePoint((Vector2D)((GenericNode)currentGraph.getNode(shellNode.getIdentifier())).getPosition(), renderer.getRenderingOptions().getNodeDiameter() + 2.0);
            }
            return null;
        });
        Application.launch(GraphDisplayApplication.class, (String[])new String[0]);
    }
}

