/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.javafx.renderer.graphs;

import de.bioforscher.singa.javafx.renderer.Renderer;
import de.bioforscher.singa.javafx.renderer.graphs.GraphProducer;
import de.bioforscher.singa.javafx.renderer.graphs.GraphRenderOptions;
import de.bioforscher.singa.mathematics.geometry.edges.LineSegment;
import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Graph;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Paint;

public class GraphRenderer<NodeType extends Node<NodeType, Vector2D, IdentifierType>, EdgeType extends Edge<NodeType>, IdentifierType, GraphType extends Graph<NodeType, EdgeType, IdentifierType>>
extends AnimationTimer
implements Renderer {
    private ConcurrentLinkedQueue<GraphType> graphQueue = new ConcurrentLinkedQueue();
    private GraphRenderOptions renderingOptions = new GraphRenderOptions();
    private Function<GraphType, Void> renderBeforeFunction;
    private Function<GraphType, Void> renderAfterFunction;
    private DoubleProperty drawingWidth = new SimpleDoubleProperty();
    private DoubleProperty drawingHeight = new SimpleDoubleProperty();
    private GraphicsContext graphicsContext;

    public void arrangeGraph(GraphType graph) {
        Thread graphProducer = new Thread(new GraphProducer(this, graph, 100));
        graphProducer.start();
        this.start();
    }

    public void handle(long now) {
        Graph graph;
        while ((graph = (Graph)this.graphQueue.poll()) != null) {
            this.fillBackground();
            if (this.renderBeforeFunction != null) {
                this.renderBeforeFunction.apply(graph);
            }
            this.render(graph);
            if (this.renderAfterFunction == null) continue;
            this.renderAfterFunction.apply(graph);
        }
    }

    public void render(GraphType graph) {
        if (this.renderingOptions.isDisplayingEdges()) {
            graph.getEdges().forEach(this::drawEdge);
        }
        if (this.renderingOptions.isDisplayingNodes()) {
            graph.getNodes().forEach(this::drawNode);
        }
    }

    public void fillBackground() {
        this.getGraphicsContext().setFill((Paint)this.renderingOptions.getBackgroundColor());
        this.getGraphicsContext().fillRect(0.0, 0.0, this.getDrawingWidth(), this.getDrawingHeight());
    }

    public void setRenderAfter(Function<GraphType, Void> renderAfterFunction) {
        this.renderAfterFunction = renderAfterFunction;
    }

    public void setRenderBefore(Function<GraphType, Void> renderBeforeFunction) {
        this.renderBeforeFunction = renderBeforeFunction;
    }

    protected void drawNode(NodeType node) {
        this.getGraphicsContext().setFill((Paint)this.renderingOptions.getNodeColor());
        this.drawPoint((Vector2D)node.getPosition(), this.renderingOptions.getNodeDiameter());
        this.getGraphicsContext().setFill((Paint)this.renderingOptions.getIdentifierTextColor());
        this.drawTextCenteredOnPoint(String.valueOf(node.getIdentifier()), (Vector2D)node.getPosition());
    }

    public ConcurrentLinkedQueue<GraphType> getGraphQueue() {
        return this.graphQueue;
    }

    protected void drawEdge(EdgeType edge) {
        this.getGraphicsContext().setLineWidth(this.renderingOptions.getEdgeThickness());
        this.getGraphicsContext().setStroke((Paint)this.renderingOptions.getEdgeColor());
        this.drawLineSegment(new LineSegment((Vector2D)edge.getSource().getPosition(), (Vector2D)edge.getTarget().getPosition()));
    }

    public DoubleProperty drawingWidthProperty() {
        return this.drawingWidth;
    }

    public DoubleProperty drawingHeightProperty() {
        return this.drawingHeight;
    }

    @Override
    public GraphicsContext getGraphicsContext() {
        return this.graphicsContext;
    }

    public void setGraphicsContext(GraphicsContext graphicsContext) {
        this.graphicsContext = graphicsContext;
    }

    @Override
    public double getDrawingWidth() {
        return this.drawingWidth.get();
    }

    @Override
    public double getDrawingHeight() {
        return this.drawingHeight.get();
    }

    public GraphRenderOptions getRenderingOptions() {
        return this.renderingOptions;
    }

    public void setRenderingOptions(GraphRenderOptions renderingOptions) {
        this.renderingOptions = renderingOptions;
    }
}

