/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.core.identifier;

import de.bioforscher.singa.core.identifier.model.AbstractIdentifier;
import de.bioforscher.singa.core.identifier.model.Identifier;
import java.util.Collection;
import java.util.Optional;
import java.util.regex.Pattern;

public class InChIKey
extends AbstractIdentifier {
    public static final Pattern PATTERN = Pattern.compile("[A-Z]{14}-[A-Z]{10}-[A-Z]");

    public InChIKey(String identifier) throws IllegalArgumentException {
        super(identifier, PATTERN);
    }

    public static Optional<Identifier> find(Collection<Identifier> identifiers) {
        for (Identifier identifier : identifiers) {
            if (!InChIKey.check(identifier)) continue;
            return Optional.of(identifier);
        }
        return Optional.empty();
    }

    public static boolean check(Identifier identifier) {
        return PATTERN.matcher(identifier.toString()).matches();
    }

    public static Pattern getPattern() {
        return PATTERN;
    }
}

