/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.core.identifier;

import de.bioforscher.singa.core.identifier.model.AbstractIdentifier;
import de.bioforscher.singa.core.identifier.model.Identifier;
import java.util.Collection;
import java.util.Optional;
import java.util.regex.Pattern;

public class ENAAccessionNumber
extends AbstractIdentifier {
    public static final Pattern PATTERN = Pattern.compile("[A-Z]{3}\\d{5}\\.\\d+");
    private ExpressionType expressionType;

    public ENAAccessionNumber(String identifier, ExpressionType expressionType) throws IllegalArgumentException {
        super(identifier, PATTERN);
        this.expressionType = expressionType;
    }

    public ExpressionType getExpressionType() {
        return this.expressionType;
    }

    public static boolean check(Identifier identifier) {
        return PATTERN.matcher(identifier.toString()).matches();
    }

    public static Optional<Identifier> find(Collection<Identifier> identifiers) {
        for (Identifier identifier : identifiers) {
            if (!ENAAccessionNumber.check(identifier)) continue;
            return Optional.of(identifier);
        }
        return Optional.empty();
    }

    public static Pattern getPattern() {
        return PATTERN;
    }

    public static enum ExpressionType {
        GENOMIC_DNA,
        MRNA;

    }
}

