/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.core.parser.rest;

import de.bioforscher.singa.core.parser.AbstractParser;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractHTMLParser<ResultType>
extends AbstractParser<ResultType> {
    public void fetchResource() {
        try {
            URL url = new URL(this.getResource());
            this.setFetchResult(url.openStream());
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException("The url \"" + this.getResource() + "\" seems to be malformed", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not connect to \"" + this.getResource() + "\", the server seems to be unavailable.", e);
        }
    }

    public void fetchResource(String resource) {
        String urlString = this.getResource() + resource;
        try {
            URL url = new URL(urlString);
            this.setFetchResult(url.openStream());
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException("The url \"" + urlString + "\" seems to be malformed", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not connect to \"" + urlString + "\", the server seems to be unavailable.", e);
        }
    }

    public void fetchWithQuery(Map<String, String> queryMap) {
        StringBuilder query = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = queryMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            query.append(entry.getKey()).append('=').append(entry.getValue());
            if (!iterator.hasNext()) continue;
            query.append('&');
        }
        this.fetchResource(query.toString());
    }
}

