/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.core.parameters;

import de.bioforscher.singa.core.parameters.BooleanParameter;
import de.bioforscher.singa.core.parameters.DoubleParameter;
import de.bioforscher.singa.core.parameters.IntegerParameter;
import de.bioforscher.singa.core.parameters.ParameterValue;
import de.bioforscher.singa.core.parameters.UniqueParameterList;
import java.math.BigDecimal;

public class ParameterSampler {
    public static UniqueParameterList<Boolean> sample(BooleanParameter parameter) {
        UniqueParameterList<Boolean> parameterSet = new UniqueParameterList<Boolean>();
        parameterSet.add(new ParameterValue<Boolean>(parameter, true));
        parameterSet.add(new ParameterValue<Boolean>(parameter, false));
        return parameterSet;
    }

    public static UniqueParameterList<Double> sample(DoubleParameter parameter, int numberOfSamples) {
        UniqueParameterList<Double> parameterSet = new UniqueParameterList<Double>();
        BigDecimal stepSize = ParameterSampler.calculateStepSize(parameter.getLowerBound(), parameter.getUpperBound(), numberOfSamples);
        BigDecimal nextStep = new BigDecimal(parameter.getLowerBound().toString());
        for (int i = 0; i < numberOfSamples; ++i) {
            parameterSet.add(new ParameterValue<Double>(parameter, nextStep.doubleValue()));
            nextStep = ParameterSampler.calculateNextStep(nextStep, stepSize);
        }
        return parameterSet;
    }

    public static UniqueParameterList<Integer> sample(IntegerParameter parameter, int numberOfSamples) {
        while ((parameter.getUpperBound() - parameter.getLowerBound()) % numberOfSamples != 0) {
            --numberOfSamples;
        }
        UniqueParameterList<Integer> parameterSet = new UniqueParameterList<Integer>();
        BigDecimal nextStep = new BigDecimal(parameter.getLowerBound().toString());
        BigDecimal stepSize = ParameterSampler.calculateStepSize(parameter.getLowerBound(), parameter.getUpperBound(), ++numberOfSamples);
        for (int i = 0; i < numberOfSamples; ++i) {
            parameterSet.add(new ParameterValue<Integer>(parameter, nextStep.intValue()));
            nextStep = ParameterSampler.calculateNextStep(nextStep, stepSize);
        }
        return parameterSet;
    }

    private static <T> BigDecimal calculateStepSize(T lowerBound, T upperBound, int numberOfSamples) {
        return ParameterSampler.calculateStepSize(new BigDecimal(lowerBound.toString()), new BigDecimal(upperBound.toString()), numberOfSamples);
    }

    private static BigDecimal calculateStepSize(BigDecimal lowerBound, BigDecimal upperBound, int numberOfSamples) {
        return upperBound.subtract(lowerBound).divide(new BigDecimal(String.valueOf(numberOfSamples - 1)), 12, 4);
    }

    private static BigDecimal calculateNextStep(BigDecimal lastStep, BigDecimal stepSize) {
        return lastStep.add(stepSize);
    }
}

