/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.benchmark.algorithms.superimposition;

import de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d.Fit3DBuilder;
import de.bioforscher.singa.chemistry.parser.pdb.structures.StructureParser;
import de.bioforscher.singa.chemistry.physical.branches.BranchSubstructure;
import de.bioforscher.singa.chemistry.physical.branches.StructuralMotif;
import de.bioforscher.singa.chemistry.physical.families.AminoAcidFamily;
import de.bioforscher.singa.chemistry.physical.model.LeafIdentifier;
import de.bioforscher.singa.chemistry.physical.model.LeafIdentifiers;
import de.bioforscher.singa.chemistry.physical.model.Structure;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Timeout;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Benchmark)
@Timeout(time=0x7FFFFFFF)
public class Fit3DAlignmentBenchmark {
    private Structure target;
    private StructuralMotif queryMotif;

    @Setup
    public void setUp() throws IOException {
        this.target = StructureParser.online().pdbIdentifier("1GL0").parse();
        Structure motifContainingStructure = StructureParser.local().fileLocation(Thread.currentThread().getContextClassLoader().getResource("1GL0_HDS_intra_E-H57_E-D102_E-S195.pdb").getFile()).parse();
        this.queryMotif = StructuralMotif.fromLeafIdentifiers((Structure)motifContainingStructure, (List)LeafIdentifiers.of((String[])new String[]{"E-57", "E-102", "E-195"}));
        this.queryMotif.addExchangeableFamily(LeafIdentifier.fromString((String)"E-57"), AminoAcidFamily.GLUTAMIC_ACID);
    }

    @Benchmark
    public void benchmarkFit3DAlignment() {
        Fit3DBuilder.create().query(this.queryMotif).target((BranchSubstructure)this.target.getAllChains().get(0)).run();
    }
}

