/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.benchmark.mathematics;

import de.bioforscher.singa.mathematics.matrices.FastMatrices;
import de.bioforscher.singa.mathematics.matrices.RegularMatrix;
import de.bioforscher.singa.mathematics.matrices.SymmetricMatrix;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Timeout;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Benchmark)
@Timeout(time=0x7FFFFFFF)
@Warmup(iterations=10)
@Measurement(iterations=5)
public class MatrixBenchmark {
    private static final int numberOfValues = 1000;
    private static final int numberOfRows = 100;
    private static final int numberOfColumns = 100;
    private List<double[][]> regularValues;
    private List<double[][]> compactValues;

    @Setup
    public void setUp() throws IOException {
        this.regularValues = new ArrayList<double[][]>();
        this.compactValues = new ArrayList<double[][]>();
        for (int iteration = 0; iteration < 1000; ++iteration) {
            int rowIndex;
            double[][] value = new double[100][100];
            for (int rowIndex2 = 0; rowIndex2 < value.length; ++rowIndex2) {
                for (int columnIndex = 0; columnIndex < value[rowIndex2].length; ++columnIndex) {
                    value[rowIndex2][columnIndex] = Math.random();
                }
            }
            this.regularValues.add(value);
            double[][] compactValues = new double[100][];
            for (rowIndex = 0; rowIndex < 100; ++rowIndex) {
                compactValues[rowIndex] = new double[rowIndex + 1];
            }
            for (rowIndex = 0; rowIndex < compactValues.length; ++rowIndex) {
                for (int columnIndex = 0; columnIndex < compactValues[rowIndex].length; ++columnIndex) {
                    compactValues[rowIndex][columnIndex] = Math.random();
                }
            }
            this.compactValues.add(compactValues);
        }
    }

    public void benchmarkRegularInitialization() {
        for (double[][] value : this.regularValues) {
            RegularMatrix regularMatrix = new RegularMatrix(value);
        }
    }

    public void benchmarkFastInitialization() {
        for (double[][] value : this.regularValues) {
            RegularMatrix regularMatrix = FastMatrices.createRegularMatrix((double[][])value);
        }
    }

    @Benchmark
    public void benchmarkRegularSymmetricInitialization() {
        for (double[][] value : this.compactValues) {
            SymmetricMatrix symmetricMatrix = new SymmetricMatrix(value);
        }
    }

    @Benchmark
    public void benchmarkFastSymmetricInitialization() {
        for (double[][] value : this.compactValues) {
            SymmetricMatrix symmetricMatrix = FastMatrices.createSymmetricMatrix((double[][])value);
        }
    }
}

