/*
 * Decompiled with CFR 0.152.
 */
package de.bildschirmarbeiter.jbake.maven.plugin;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jbake.app.Oven;

@Mojo(name="bake", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class BakeMojo
extends AbstractMojo {
    @Parameter(property="jbake.source", defaultValue="src/main/jbake")
    protected File source;
    @Parameter(property="jbake.destination", defaultValue="target/jbake")
    protected File destination;
    @Parameter(property="jbake.clearCache", defaultValue="true")
    protected boolean clearCache;
    @Parameter(property="jbake.failOnError", defaultValue="true")
    protected boolean failOnError;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Executing Bake Mojo");
        try {
            this.bake();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Baking failed", e);
        }
    }

    protected void bake() throws Exception {
        this.getLog().info((CharSequence)String.format("Baking from %s to %s (clearing cache: %s)", this.source, this.destination, this.clearCache));
        Oven oven = new Oven(this.source, this.destination, this.clearCache);
        oven.setupPaths();
        oven.bake();
        if (this.failOnError && !oven.getErrors().isEmpty()) {
            throw new Exception("Baked with errors: " + oven.getErrors().size());
        }
    }
}

