/*
 * Decompiled with CFR 0.152.
 */
package de.bildschirmarbeiter.jbake.maven.plugin;

import de.bildschirmarbeiter.jbake.maven.plugin.WatchMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;

@Mojo(name="serve")
public class ServeMojo
extends WatchMojo {
    @Parameter(property="jbake.port", defaultValue="8080")
    protected Integer port;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Executing Serve Mojo");
        try {
            this.bake();
            new Thread(this::watch).start();
            this.serve();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Serving failed", e);
        }
    }

    protected void serve() throws Exception {
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase(this.destination.getPath());
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{resourceHandler, new DefaultHandler()});
        Server server = new Server(this.port.intValue());
        server.setHandler((Handler)handlers);
        server.start();
        this.getLog().info((CharSequence)"Hit CTRL-C to stop.");
        server.join();
    }
}

