/*
 * Decompiled with CFR 0.152.
 */
package de.bildschirmarbeiter.jbake.maven.plugin;

import de.bildschirmarbeiter.jbake.maven.plugin.BakeMojo;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="watch")
public class WatchMojo
extends BakeMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Executing Watch Mojo");
        try {
            this.bake();
            this.watch();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Watching failed", e);
        }
    }

    protected void watch() {
        this.getLog().info((CharSequence)String.format("Watching in %s for file changes", this.source));
        try {
            FileSystemManager fileSystemManager = VFS.getManager();
            FileObject source = fileSystemManager.resolveFile(this.source.getAbsolutePath());
            DefaultFileMonitor fileMonitor = new DefaultFileMonitor((FileListener)new SourceFileListener());
            fileMonitor.setRecursive(true);
            fileMonitor.addFile(source);
            fileMonitor.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private final class SourceFileListener
    implements FileListener {
        private SourceFileListener() {
        }

        public void fileCreated(FileChangeEvent fileChangeEvent) throws Exception {
            WatchMojo.this.getLog().info((CharSequence)String.format("File created: %s", fileChangeEvent.getFile().getName()));
            WatchMojo.this.bake();
        }

        public void fileDeleted(FileChangeEvent fileChangeEvent) throws Exception {
            WatchMojo.this.getLog().info((CharSequence)String.format("File deleted: %s", fileChangeEvent.getFile().getName()));
            WatchMojo.this.bake();
        }

        public void fileChanged(FileChangeEvent fileChangeEvent) throws Exception {
            WatchMojo.this.getLog().info((CharSequence)String.format("File changed: %s", fileChangeEvent.getFile().getName()));
            WatchMojo.this.bake();
        }
    }
}

