/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.FieldTypePair;
import de.bild.codec.MethodTypePair;
import de.bild.codec.annotations.Id;
import de.bild.codec.annotations.LockingVersion;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.TypeUtils;

public abstract class ReflectionHelper {
    public static List<FieldTypePair> getDeclaredAndInheritedFieldTypePairs(Type type, boolean returnFinalFields) {
        ArrayList<FieldTypePair> list = new ArrayList<FieldTypePair>();
        ReflectionHelper.getFieldTypePairsRecursive(type, returnFinalFields, list, null);
        return list;
    }

    private static void getFieldTypePairsRecursive(Type type, boolean returnFinalFields, List<FieldTypePair> currentList, Map<String, Type> realTypeMap) {
        if (type instanceof ParameterizedType) {
            ReflectionHelper.getFieldTypePairsRecursive((ParameterizedType)type, returnFinalFields, currentList, realTypeMap);
        } else if (type instanceof Class) {
            ReflectionHelper.getFieldTypePairsRecursive(TypeUtils.parameterize((Class)((Class)type), (Type[])((Class)type).getTypeParameters()), returnFinalFields, currentList, realTypeMap);
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type upperBoundType = wildcardType.getUpperBounds()[0];
            ReflectionHelper.getFieldTypePairsRecursive(upperBoundType, returnFinalFields, currentList, realTypeMap);
        } else {
            throw new IllegalArgumentException("Unknown type." + type);
        }
    }

    private static void getFieldTypePairsRecursive(ParameterizedType type, boolean returnFinalFields, List<FieldTypePair> currentList, Map<String, Type> realTypeMap) {
        if (type.getRawType() == Object.class) {
            return;
        }
        Type[] actualTypeArguments = type.getActualTypeArguments();
        Type[] inferredTypeArguments = new Type[actualTypeArguments.length];
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            Type currentTypeParameter = actualTypeArguments[i];
            inferredTypeArguments[i] = ReflectionHelper.inferRealType(currentTypeParameter, realTypeMap);
        }
        Class rawClass = (Class)type.getRawType();
        Map<String, Type> clazzTypeParameterMap = ReflectionHelper.calculateInferredTypeParameters(rawClass, inferredTypeArguments);
        ReflectionHelper.getFieldTypePairsRecursive(rawClass.getGenericSuperclass(), returnFinalFields, currentList, clazzTypeParameterMap);
        List<Field> validFields = ReflectionHelper.getValidFields(rawClass.getDeclaredFields(), returnFinalFields);
        for (Field validField : validFields) {
            currentList.add(new FieldTypePair(validField, ReflectionHelper.inferRealType(validField.getGenericType(), clazzTypeParameterMap)));
        }
    }

    public static Map<String, Type> calculateInferredTypeParameters(Class clazz, Type[] actualTypeParameters) {
        HashMap<String, Type> newRealTypeMap = new HashMap<String, Type>();
        TypeVariable<Class<T>>[] typeParameters = clazz.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            TypeVariable typeVariable = typeParameters[i];
            Type bound = typeVariable.getBounds()[0];
            if (actualTypeParameters != null) {
                bound = actualTypeParameters[i];
            }
            newRealTypeMap.put(typeVariable.getName(), ReflectionHelper.inferRealType(bound, newRealTypeMap));
        }
        return newRealTypeMap;
    }

    public static Type inferRealType(Type type, Map<String, Type> realTypeMap) {
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type genericComponentType = genericArrayType.getGenericComponentType();
            return TypeUtils.genericArrayType((Type)ReflectionHelper.inferRealType(genericComponentType, realTypeMap));
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType bound = (ParameterizedType)type;
            ArrayList<Type> typeList = new ArrayList<Type>();
            for (int i = 0; i < bound.getActualTypeArguments().length; ++i) {
                typeList.add(ReflectionHelper.inferRealType(bound.getActualTypeArguments()[i], realTypeMap));
            }
            return TypeUtils.parameterizeWithOwner((Type)bound.getOwnerType(), (Class)((Class)bound.getRawType()), (Type[])typeList.toArray(new Type[0]));
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return TypeUtils.wildcardType().withLowerBounds(ReflectionHelper.inferRealTypes(wildcardType.getLowerBounds(), realTypeMap)).withUpperBounds(ReflectionHelper.inferRealTypes(wildcardType.getUpperBounds(), realTypeMap)).build();
        }
        if (type instanceof TypeVariable) {
            if (realTypeMap == null) {
                return ((TypeVariable)type).getBounds()[0];
            }
            return realTypeMap.get(type.getTypeName());
        }
        return type;
    }

    private static Type[] inferRealTypes(Type[] bounds, Map<String, Type> realTypeMap) {
        Type[] newBounds = new Type[bounds.length];
        for (int i = 0; i < bounds.length; ++i) {
            newBounds[i] = ReflectionHelper.inferRealType(bounds[i], realTypeMap);
        }
        return newBounds;
    }

    private static List<Field> getValidFields(Field[] fields, boolean returnFinalFields) {
        ArrayList<Field> validFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers()) || !returnFinalFields && Modifier.isFinal(field.getModifiers())) continue;
            validFields.add(field);
        }
        return validFields;
    }

    public static List<MethodTypePair> getDeclaredAndInheritedMethods(Type type) {
        ArrayList<MethodTypePair> list = new ArrayList<MethodTypePair>();
        ReflectionHelper.getMethodTypePairsRecursive(type, list, null);
        return list;
    }

    private static void getMethodTypePairsRecursive(Type type, List<MethodTypePair> currentList, Map<String, Type> realTypeMap) {
        if (type instanceof ParameterizedType) {
            ReflectionHelper.getMethodTypePairsRecursive((ParameterizedType)type, currentList, realTypeMap);
        } else if (type instanceof Class) {
            ReflectionHelper.getMethodTypePairsRecursive(TypeUtils.parameterize((Class)((Class)type), (Type[])((Class)type).getTypeParameters()), currentList, realTypeMap);
        } else {
            throw new IllegalArgumentException("Unknown type." + type);
        }
    }

    private static void getMethodTypePairsRecursive(ParameterizedType type, List<MethodTypePair> currentList, Map<String, Type> realTypeMap) {
        if (type.getRawType() == Object.class) {
            return;
        }
        Type[] actualTypeArguments = type.getActualTypeArguments();
        Type[] inferredTypeArguments = new Type[actualTypeArguments.length];
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            Type currentTypeParameter = actualTypeArguments[i];
            inferredTypeArguments[i] = ReflectionHelper.inferRealType(currentTypeParameter, realTypeMap);
        }
        Class rawClass = (Class)type.getRawType();
        Map<String, Type> clazzTypeParameterMap = ReflectionHelper.calculateInferredTypeParameters(rawClass, inferredTypeArguments);
        ReflectionHelper.getMethodTypePairsRecursive(rawClass.getGenericSuperclass(), currentList, clazzTypeParameterMap);
        for (Method method : rawClass.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            currentList.add(new MethodTypePair(method, ReflectionHelper.inferRealType(method.getGenericReturnType(), clazzTypeParameterMap)));
        }
    }

    private static FieldTypePair getAnnotatedFieldIfPresent(Class clazz, Class<? extends Annotation> annotationClass) {
        for (FieldTypePair fieldTypePair : ReflectionHelper.getDeclaredAndInheritedFieldTypePairs(clazz, true)) {
            Field field = fieldTypePair.getField();
            if (!field.isAnnotationPresent(annotationClass)) continue;
            return fieldTypePair;
        }
        return null;
    }

    public static FieldTypePair getIdFieldIfPresent(Class clazz) {
        return ReflectionHelper.getAnnotatedFieldIfPresent(clazz, Id.class);
    }

    public static FieldTypePair getLockingVersionFieldIfPresent(Class clazz) {
        return ReflectionHelper.getAnnotatedFieldIfPresent(clazz, LockingVersion.class);
    }

    public static Type findInterface(Type type, Class interfaceToFind) {
        return ReflectionHelper.findInterface(type, interfaceToFind, null);
    }

    private static Type findInterface(Type type, Class interfaceToFind, Map<String, Type> realTypeMap) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return ReflectionHelper.findInterface(parameterizedType, interfaceToFind, realTypeMap);
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return ReflectionHelper.findInterface(TypeUtils.parameterize((Class)clazz, (Type[])clazz.getTypeParameters()), interfaceToFind, realTypeMap);
        }
        return null;
    }

    private static Type findInterface(ParameterizedType type, Class interfaceToFind, Map<String, Type> realTypeMap) {
        if (type.getRawType() == Object.class) {
            return null;
        }
        Class rawClass = (Class)type.getRawType();
        if (rawClass == interfaceToFind) {
            return ReflectionHelper.inferRealType(type, realTypeMap);
        }
        Type[] actualTypeArguments = type.getActualTypeArguments();
        Type[] inferredTypeArguments = new Type[actualTypeArguments.length];
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            Type currentTypeParameter = actualTypeArguments[i];
            inferredTypeArguments[i] = ReflectionHelper.inferRealType(currentTypeParameter, realTypeMap);
        }
        Map<String, Type> clazzTypeParameterMap = ReflectionHelper.calculateInferredTypeParameters(rawClass, inferredTypeArguments);
        for (Type genericInterface : rawClass.getGenericInterfaces()) {
            Type foundInterface = ReflectionHelper.findInterface(genericInterface, interfaceToFind, clazzTypeParameterMap);
            if (foundInterface == null) continue;
            return foundInterface;
        }
        return ReflectionHelper.findInterface(rawClass.getGenericSuperclass(), interfaceToFind, clazzTypeParameterMap);
    }

    public static Class extractRawClass(Type type) {
        return TypeUtils.getRawType((Type)type, null);
    }
}

