/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import com.google.common.reflect.AbstractInvocationHandler;
import de.bild.codec.CodecResolver;
import de.bild.codec.PojoContext;
import de.bild.codec.TypeCodec;
import de.bild.codec.TypesModel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoCodecProvider
implements CodecProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PojoCodecProvider.class);
    private final TypesModel typesModel;
    private final PojoContext pojoContext;

    PojoCodecProvider(Set<Class<?>> classes, Set<String> packages, List<CodecResolver> codecResolvers) {
        this.typesModel = new TypesModel(classes, packages);
        this.pojoContext = new PojoContext(this.typesModel, codecResolvers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        Codec<T> codec = this.pojoContext.get(clazz, registry);
        if (codec instanceof TypeCodec) {
            TypeCodec typeCodec;
            if (clazz != null && clazz.getTypeParameters().length > 0) {
                LOGGER.warn("Generic classes will only be encoded/decoded with their upper bounds! We could prohibit handling of the pojo codec for those generic classes, but then user would loose flexibility when subclassing such classes. Class: " + clazz.toGenericString());
            }
            if ((typeCodec = (TypeCodec)codec).isCollectible()) {
                LOGGER.debug("Enhancing {} to be collectible codec.", (Object)typeCodec);
                Class[] proxyInterfaces = new Class[]{CollectibleCodec.class};
                CollectibleCodec collectibleCodec = (CollectibleCodec)Proxy.newProxyInstance(PojoCodecProvider.class.getClassLoader(), proxyInterfaces, new CollectibleCodecDelegator(typeCodec));
                return collectibleCodec;
            }
        }
        return codec;
    }

    public static class Builder {
        private Set<String> packages = new HashSet<String>();
        private Set<Class<?>> classes = new HashSet();
        private List<CodecResolver> codecResolvers = new ArrayList<CodecResolver>();

        private Builder() {
        }

        public Builder setPackages(Set<String> packages) {
            this.packages = packages;
            return this;
        }

        public Builder register(String ... packages) {
            this.packages.addAll(Arrays.asList(packages));
            return this;
        }

        public Builder register(Class<?> ... classes) {
            this.classes.addAll(Arrays.asList(classes));
            return this;
        }

        public Builder registerCodecResolver(CodecResolver ... codecResolvers) {
            this.codecResolvers.addAll(Arrays.asList(codecResolvers));
            return this;
        }

        public PojoCodecProvider build() {
            return new PojoCodecProvider(this.classes, this.packages, this.codecResolvers);
        }
    }

    private static class CollectibleCodecDelegator<T>
    extends AbstractInvocationHandler
    implements CollectibleCodec<T> {
        private final TypeCodec<T> delegatingCodec;

        public CollectibleCodecDelegator(TypeCodec<T> delegatingCodec) {
            this.delegatingCodec = delegatingCodec;
        }

        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warn("An exception was caught while invoking the delegate {} with args {}", (Object)method, (Object)args);
                LOGGER.debug("Original exception when invoking target.", (Throwable)e);
                throw e.getCause();
            }
        }

        public T generateIdIfAbsentFromDocument(T document) {
            return this.delegatingCodec.generateIdIfAbsentFromDocument(document);
        }

        public boolean documentHasId(T document) {
            return this.delegatingCodec.documentHasId(document);
        }

        public BsonValue getDocumentId(T document) {
            return this.delegatingCodec.getDocumentId(document);
        }

        public T decode(BsonReader reader, DecoderContext decoderContext) {
            return (T)this.delegatingCodec.decode(reader, decoderContext);
        }

        public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
            this.delegatingCodec.encode(writer, value, encoderContext);
        }

        public Class<T> getEncoderClass() {
            return this.delegatingCodec.getEncoderClass();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

