/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.CollectionTypeCodec;
import de.bild.codec.ReflectionHelper;
import de.bild.codec.TypeCodecRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ListTypeCodec<C extends List<V>, V>
extends CollectionTypeCodec<C, V> {
    public ListTypeCodec(Class<C> collectionClass, Type valueType, TypeCodecRegistry typeCodecRegistry) {
        super(collectionClass, valueType, typeCodecRegistry);
    }

    @Override
    protected Constructor<C> getDefaultConstructor(Class<C> clazz) {
        if (clazz.isInterface()) {
            return super.getDefaultConstructor(ArrayList.class);
        }
        return super.getDefaultConstructor(clazz);
    }

    public static ListTypeCodec getCodecIfApplicable(Type type, TypeCodecRegistry typeCodecRegistry) {
        Type listInterface;
        Class rawClass = ReflectionHelper.extractRawClass(type);
        if (rawClass != null && List.class.isAssignableFrom(rawClass) && (listInterface = ReflectionHelper.findInterface(type, List.class)) instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)listInterface;
            return new ListTypeCodec(rawClass, parameterizedType.getActualTypeArguments()[0], typeCodecRegistry);
        }
        return null;
    }
}

