/*
 * #%L
 * A Maven Plugin for the Google App Engine
 * %%
 * Copyright (C) 2013 None
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package de.bigmichi1.appengine.devserver;

import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import java.util.ArrayList;
import java.util.List;

/**
 * Mojo for running the DevAppServer in debug mode.
 *
 * @author Michael Cramer
 * @version 1.7.5
 * @since 1.7.5
 */
@Mojo(name = "devserver-debug")
@Execute(phase = LifecyclePhase.PACKAGE)
public class DevServerDebugMojo extends AbstractDevServerMojo {
    /**
     * The port number for debugging.
     */
    @Parameter(property = "appengine.debugPort", defaultValue = "5005")
    private Integer debugPort;
    /**
     * Suspend the JVM until debugger is attached.
     */
    @Parameter(property = "appengine.debugSuspend", defaultValue = "false")
    private boolean debugSuspend;

    /**
     * {@inheritDoc}
     */
    @Override
    protected final List<String> collectAdditionalMojoParams() {
        final List<String> mojoParams = new ArrayList<String>(1);

        if (debugPort != null) {
            final String debugFlag = debugSuspend ? "y" : "n";
            mojoParams.add("--jvm_flag=\"-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + debugFlag + ",address=" + Integer.toString(debugPort) + "\"");
        }

        return mojoParams;
    }
}
