/*
 * #%L
 * A Maven Plugin for the Google App Engine
 * %%
 * Copyright (C) 2013 None
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package de.bigmichi1.appengine.util;

import javax.annotation.Nonnull;
import java.util.List;

/**
 * Write the password to the console prompt for AppCfg. This method is a copy and slightly modified version of the
 * one that is used in the "maven-gae-plugin".
 *
 * @author rhansen@kindleit.net
 * @author Michael Cramer
 * @version 1.7.5
 * @since 1.7.5
 */
public class PasswordUtil {
    /**
     * Handler for getting the actual maven logger.
     */
    @Nonnull
    private final LogHandler log;

    /**
     * Main constructor.
     *
     * @param logHandler maven logging accessor
     */
    public PasswordUtil(@Nonnull final LogHandler logHandler) {
        log = logHandler;
    }

    /**
     * Runs the {@link com.google.appengine.tools.admin.AppCfg#main(String[])} with the given arguments and password.
     *
     * @param args     arguments for {@link com.google.appengine.tools.admin.AppCfg}
     * @param password password in plain text
     */
    public final void forkPasswordExpectThread(@Nonnull final List<String> args, @Nonnull final String password) {
        // Parent for all threads created by AppCfg
        final ThreadGroup threads = new ThreadGroup("AppCfgThreadGroup");
        // Main execution Thread that belong to ThreadGroup threads
        final Thread thread = new PasswordAppCfgMainThread(log, threads, password, args);
        thread.start();
        try {
            thread.join();
        } catch (final InterruptedException e) {
            log.getLog().error("Interrupted waiting for process supervisor thread to finish", e);
        }
    }
}
