/*
 * #%L
 * A Maven Plugin for the Google App Engine
 * %%
 * Copyright (C) 2013 None
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package de.bigmichi1.appengine.util;

import org.apache.maven.plugin.logging.Log;

import javax.annotation.Nonnull;

/**
 * Handler for getting the actual logger from the plugin.
 *
 * @author Michael Cramer
 * @version 1.7.5
 * @since 1.7.5
 */
public interface LogHandler {
    /**
     * Get the actual logger from maven execution.
     *
     * @return logger
     */
    @Nonnull
    Log getLog();
}
