/*
 * #%L
 * A Maven Plugin for the Google App Engine
 * %%
 * Copyright (C) 2013 None
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package de.bigmichi1.appengine.appcfg;

import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

import javax.annotation.Nonnull;
import java.util.Collections;
import java.util.List;

/**
 * AppCfg "update_cron" Mojo.<br/>
 * Updates the cron jobs for the server. Updates any new, removed or changed cron jobs.<br/>
 * Does not otherwise alter the running application version.
 *
 * @author Michael Cramer
 * @version 1.7.5
 * @since 1.7.5
 */
@Mojo(name = "update_cron")
@Execute(phase = LifecyclePhase.PACKAGE)
public class AppCfgUpdateCronMojo extends AbstractBaseAppCfgMojo {
    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    protected final String getActionName() {
        return "update_cron";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected final void addLogMessages() {
        getLog().info("");
        getLog().info("Google App Engine Java SDK - Update application cron jobs");
        getLog().info("");
    }

    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    protected final List<String> collectActionParams() {
        return Collections.emptyList();
    }
}
