/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.jsf.ajax.differentialContextWriter.parser;

import de.beyondjava.jsf.ajax.differentialContextWriter.parser.HTMLAttribute;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HTMLTag
implements Serializable {
    private static transient DocumentBuilder builder;
    private static final Logger LOGGER;
    private static final long serialVersionUID = 8958589454536115945L;
    private List<HTMLAttribute> attributes = new ArrayList<HTMLAttribute>();
    private List<HTMLTag> children = new ArrayList<HTMLTag>();
    private String id = "";
    private StringBuffer innerHTML = new StringBuffer();
    private boolean isCDATANode = false;
    private boolean isCommentNode = false;
    private boolean isTextNode = false;
    private String nodeName = "";
    private HTMLTag parent = null;

    private static String escapeXmlEntities(String html) {
        return html.replace("&", "AmPeRsAnD");
    }

    private static Node getXMLRootNode(Node document) {
        if (document.getNodeType() == 9) {
            document = document.getFirstChild();
            while ((document.getNodeType() == 10 || document.getNodeType() == 8) && document.getNextSibling() != null) {
                document = document.getNextSibling();
            }
        }
        return document;
    }

    private static Document htmlToDocument(String html) {
        int pos;
        long DEBUG_startTime = System.nanoTime();
        if (html.trim().startsWith("<?") && (pos = html.indexOf("?>")) > 0) {
            html = html.substring(pos + 2).trim();
        }
        if (html.startsWith("<head>")) {
            html = "<html>" + html + "</html>";
        }
        html = HTMLTag.escapeXmlEntities(html);
        InputSource inputSource = new InputSource(new StringReader(html));
        try {
            Document domTree = builder.parse(inputSource);
            long DEBUG_time = System.nanoTime() - DEBUG_startTime;
            if (null == FacesContext.getCurrentInstance() || FacesContext.getCurrentInstance().getApplication().getProjectStage() == ProjectStage.Development) {
                // empty if block
            }
            return domTree;
        }
        catch (SAXException e) {
            if (!e.getMessage().contains("]]>")) {
                LOGGER.severe("Couldn't parse the HTML oder XML code due to a SAXException. This may have been caused by an application exception.");
            } else {
                LOGGER.severe("Couldn't parse the HTML oder XML code due to a SAXException. The HTML code is:");
                LOGGER.severe(html);
            }
            throw new RuntimeException("Couldn't parse the HTML oder XML code due to a SAXException", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't parse the HTML oder XML code due to an IOException", e);
        }
    }

    private static String unescapeXmlEntities(String html) {
        return html.replace("AmPeRsAnD", "&");
    }

    public HTMLTag(Node node, HTMLTag parent) {
        this.parent = parent;
        boolean bl = this.isTextNode = node.getNodeType() == 3;
        if (this.isTextNode) {
            this.innerHTML.append(HTMLTag.unescapeXmlEntities(node.getNodeValue().trim()));
        } else if (node.getNodeType() == 4) {
            this.isTextNode = true;
            this.isCDATANode = true;
            this.innerHTML.append(HTMLTag.unescapeXmlEntities(node.getNodeValue().trim()));
        } else if (node.getNodeType() == 8) {
            this.isCommentNode = true;
            this.innerHTML.append(HTMLTag.unescapeXmlEntities(node.getNodeValue().trim()));
        } else {
            Node item;
            int i;
            this.nodeName = node.getNodeName();
            if (null != node.getAttributes()) {
                for (i = 0; i < node.getAttributes().getLength(); ++i) {
                    item = node.getAttributes().item(i);
                    this.addAttribute(item.getNodeName(), HTMLTag.unescapeXmlEntities(item.getNodeValue()));
                }
                if (null != parent) {
                    this.generateSyntheticID(node, parent);
                }
            }
            if (null != node.getChildNodes()) {
                for (i = 0; i < node.getChildNodes().getLength(); ++i) {
                    item = node.getChildNodes().item(i);
                    short type = item.getNodeType();
                    if (type == 8 || type == 3 && (item.getNodeValue() == null || item.getNodeValue().trim().length() <= 0)) continue;
                    HTMLTag kid = new HTMLTag(item, this);
                    this.children.add(kid);
                }
            }
            if (node.getNodeValue() != null && node.getNodeValue().trim().length() > 0) {
                LOGGER.warning("NodeValue nonempty?");
            }
        }
    }

    public HTMLTag(String html) {
        this(HTMLTag.getXMLRootNode(HTMLTag.htmlToDocument(html)), null);
    }

    public HTMLTag(String tag, String id, String cdata) {
        this.nodeName = tag;
        this.id = id;
        if (null != cdata) {
            HTMLTag inner = new HTMLTag(null, null, null);
            inner.innerHTML.append(cdata.trim());
            inner.isTextNode = true;
            inner.isCDATANode = true;
            inner.parent = this;
            this.children.add(inner);
        }
    }

    public void addAttribute(String name, String value) {
        HTMLAttribute a = new HTMLAttribute();
        a.name = name;
        a.value = value;
        this.attributes.add(a);
        if ("id".equals(name)) {
            this.id = value;
        }
    }

    private String attributesToString() {
        StringBuffer result = new StringBuffer();
        if (null != this.id && this.id.length() > 0) {
            result.append(' ');
            result.append("id");
            result.append('=');
            result.append('\"');
            result.append(this.id);
            result.append('\"');
        }
        if (null != this.attributes) {
            for (HTMLAttribute a : this.attributes) {
                if ("id".equals(a.name)) continue;
                result.append(' ');
                result.append(a.name);
                result.append('=');
                result.append('\"');
                result.append(a.value);
                result.append('\"');
            }
        }
        return result.toString();
    }

    public Map<String, HTMLTag> collectScripts() {
        HashMap<String, HTMLTag> scripts = new HashMap<String, HTMLTag>();
        for (HTMLTag candidate : this.children) {
            if ("script".equals(candidate.getNodeName())) {
                String scriptID = candidate.getId();
                if (null == scriptID || scriptID.length() <= 0) continue;
                if (scriptID.endsWith("_s")) {
                    scriptID = scriptID.substring(0, scriptID.length() - 2);
                }
                if (scripts.containsKey(scriptID)) continue;
                scripts.put(scriptID, candidate);
                continue;
            }
            Map<String, HTMLTag> collectScripts = candidate.collectScripts();
            if (collectScripts.isEmpty()) continue;
            for (String key : collectScripts.keySet()) {
                if (scripts.containsKey(key)) continue;
                scripts.put(key, collectScripts.get(key));
            }
        }
        return scripts;
    }

    public Collection<HTMLTag> extractPrimeFacesJavascript(Map<String, HTMLTag> availableScripts) {
        HashMap<String, HTMLTag> requiredScripts = new HashMap<String, HTMLTag>();
        if (this.id != null && this.id.length() > 0) {
            for (Map.Entry<String, HTMLTag> script : availableScripts.entrySet()) {
                if (!this.id.startsWith(script.getKey())) continue;
                requiredScripts.put(script.getKey(), script.getValue());
            }
        }
        List<HTMLTag> kids = this.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            HTMLTag child = kids.get(i);
            Collection<HTMLTag> list = child.extractPrimeFacesJavascript(availableScripts);
            for (HTMLTag t : list) {
                if (requiredScripts.containsKey(t.id)) continue;
                requiredScripts.put(t.id, t);
            }
        }
        return requiredScripts.values();
    }

    public HTMLTag findByID(String id) {
        if (this.getId().equals(id)) {
            return this;
        }
        for (HTMLTag child : this.getChildren()) {
            HTMLTag result = child.findByID(id);
            if (null == result) continue;
            return result;
        }
        return null;
    }

    public HTMLTag findTag(String tagName) {
        if (this.getNodeName().equals(tagName)) {
            return this;
        }
        if (null != this.children) {
            for (HTMLTag c : this.children) {
                if (!c.getNodeName().equals(tagName)) continue;
                return c;
            }
        }
        return null;
    }

    private String generateShorthandID(String syntheticID) {
        return syntheticID;
    }

    private void generateSyntheticID(Node node, HTMLTag parent) {
        if ((this.id == null || this.id.length() == 0) && ("span".equals(this.nodeName) || "input".equals(this.nodeName) || "a".equals(this.nodeName) || "table".equals(this.nodeName) || "tbody".equals(this.nodeName) || "tr".equals(this.nodeName) || "td".equals(this.nodeName) || "option".equals(this.nodeName))) {
            boolean omitID = false;
            if ("td".equals(this.nodeName) && node.getNodeType() == 1 && node.getChildNodes().getLength() == 1 && node.getFirstChild().getNodeType() == 3 && node.getTextContent().trim().length() < 30) {
                omitID = true;
            }
            if (!omitID) {
                if (parent.getId() != null && parent.getId().length() > 0) {
                    String syntheticID = parent.getId() + ":" + this.nodeName + parent.getChildren().size();
                    syntheticID = this.generateShorthandID(syntheticID);
                    this.addAttribute("id", syntheticID);
                } else if (parent.getNodeName().equals("body")) {
                    String syntheticID = parent.getNodeName() + ":" + this.nodeName + parent.getChildren().size();
                    syntheticID = this.generateShorthandID(syntheticID);
                    this.addAttribute("id", syntheticID);
                }
            }
        }
    }

    public HTMLAttribute getAttribute(String attributeName) {
        for (HTMLAttribute a : this.attributes) {
            if (!a.name.equals(attributeName)) continue;
            return a;
        }
        return null;
    }

    public List<HTMLAttribute> getAttributes() {
        return this.attributes;
    }

    public List<HTMLTag> getChildren() {
        return this.children;
    }

    public String getDescription() {
        if (this.id == null || this.id.length() == 0) {
            if (this.isCDATANode) {
                return "<![CDATA[" + this.innerHTML.toString() + "]]>";
            }
            if (this.isTextNode) {
                return this.innerHTML.toString();
            }
            String result = "<" + this.nodeName + this.attributesToString();
            result = result + ">";
            for (HTMLTag kid : this.children) {
                if (kid.isTextNode()) {
                    result = result + kid.innerHTML.toString();
                    continue;
                }
                if (!kid.isCDATANode) continue;
                result = result + "<![CDATA[" + kid.innerHTML.toString() + "]]>";
            }
            result = result + "</" + this.nodeName + ">";
            return result;
        }
        return this.id;
    }

    public HTMLTag getFirstChild() {
        if (this.children.size() == 0) {
            return null;
        }
        return this.children.get(0);
    }

    public String getId() {
        return this.id;
    }

    public StringBuffer getInnerHTML() {
        return this.innerHTML;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public HTMLTag getParent() {
        return this.parent;
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public boolean isCDATANode() {
        return this.isCDATANode;
    }

    public boolean isCommentNode() {
        return this.isCommentNode;
    }

    public boolean isTextNode() {
        return this.isTextNode;
    }

    public void removeChild(HTMLTag tagToBeRemoved) {
        this.children.remove(tagToBeRemoved);
    }

    public void replaceChild(HTMLTag newSubtree, HTMLTag tagToBeReplaced) {
        if (null != this.children) {
            for (int i = 0; i < this.children.size(); ++i) {
                if (this.children.get(i) != tagToBeReplaced) continue;
                this.children.set(i, newSubtree);
                newSubtree.setParent(this);
                break;
            }
        }
    }

    public void setAttribute(String name, String value) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            HTMLAttribute a = this.attributes.get(i);
            if (!a.name.equals(name)) continue;
            if (value == null) {
                this.attributes.remove(i);
            } else {
                a.value = value;
            }
            return;
        }
        HTMLAttribute newAttribute = new HTMLAttribute();
        newAttribute.name = name;
        newAttribute.value = value;
        this.attributes.add(newAttribute);
    }

    public void setAttributes(List<HTMLAttribute> attributes) {
        this.attributes = attributes;
    }

    public void setChildren(List<HTMLTag> children) {
        this.children = children;
    }

    public void setCommentNode(boolean isCommentNode) {
        this.isCommentNode = isCommentNode;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setInnerHTML(StringBuffer innerHTML) {
        this.innerHTML = innerHTML;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setParent(HTMLTag parent) {
        this.parent = parent;
    }

    public void setTextNode(boolean isTextNode) {
        this.isTextNode = isTextNode;
    }

    public String toCompactString() {
        StringBuffer s = new StringBuffer();
        return this.toCompactString(s).toString();
    }

    public StringBuffer toCompactString(StringBuffer result) {
        if (this.isCDATANode) {
            result.append("<![CDATA[");
            result.append(this.innerHTML);
            result.append("]]>");
            return result;
        }
        if (this.isTextNode) {
            result.append(this.innerHTML);
            return result;
        }
        result.append("<");
        result.append(this.nodeName);
        result.append(this.attributesToString());
        if (this.children.size() == 0 && this.innerHTML.length() == 0) {
            result.append("></");
            result.append(this.nodeName);
            result.append(">");
        } else {
            result.append(">");
            for (HTMLTag kid : this.children) {
                if (!kid.isTextNode()) {
                    kid.toCompactString(result);
                    continue;
                }
                if (kid.isCDATANode) {
                    result.append("<![CDATA[");
                    result.append(kid.innerHTML);
                    result.append("]]>");
                    continue;
                }
                result.append(kid.innerHTML);
            }
            result.append("</");
            result.append(this.nodeName);
            result.append('>');
        }
        return result;
    }

    public String toString() {
        return this.toStringIntern().replace("  </", "</");
    }

    private String toStringIntern() {
        if (this.isCDATANode) {
            return "<![CDATA[" + this.innerHTML.toString() + "]]>";
        }
        if (this.isTextNode) {
            return this.innerHTML.toString();
        }
        String result = "<" + this.nodeName + this.attributesToString();
        if (this.children.size() == 0 && this.innerHTML.length() == 0) {
            result = result + "></" + this.nodeName + ">";
        } else {
            result = result + ">";
            boolean newLineRequired = false;
            for (HTMLTag kid : this.children) {
                if (!kid.isTextNode()) {
                    String k = kid.toStringIntern().replace("  <", "    <");
                    result = result + "\n";
                    newLineRequired = true;
                    result = result + "  " + k;
                    continue;
                }
                if (kid.isCDATANode) {
                    return "<![CDATA[" + kid.innerHTML.toString() + "]]>";
                }
                result = result + kid.innerHTML.toString();
            }
            if (newLineRequired && !result.endsWith("\n")) {
                result = result + "\n";
            }
            if (result.endsWith("\n")) {
                result = result + "  ";
            }
            result = result + "</" + this.nodeName + ">\n";
        }
        return result;
    }

    static {
        LOGGER = Logger.getLogger("de.beyondjava.jsf.ajax.differentialContextWriter.differenceEngine.DiffenceEngine");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/namespaces", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setValidating(false);
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Couldn't initialize the SAX parser.", e);
        }
    }
}

