/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.jsf.ajax.differentialContextWriter.differenceEngine;

import de.beyondjava.jsf.ajax.differentialContextWriter.differenceEngine.BabbageConfiguration;
import de.beyondjava.jsf.ajax.differentialContextWriter.parser.HTMLAttribute;
import de.beyondjava.jsf.ajax.differentialContextWriter.parser.HTMLTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public class XmlDiff {
    public static final boolean ADDED_LOCAL_CHANGE = true;
    public static final boolean GLOBAL_CHANGE_REQUIRED = false;
    private static final Logger LOGGER = Logger.getLogger("de.beyondjava.jsf.ajax.differentialContextWriter.differenceEngine.XmlDiff");
    public static final boolean NO_CHANGE_REQUIRED = true;

    private static boolean areStringsEqualOrCanBeChangedLocally(String oldString, String newString) {
        if (oldString == null && newString == null) {
            return true;
        }
        if (oldString == null || newString == null) {
            return false;
        }
        return oldString.equals(newString);
    }

    private static void assertTagIDMatch(List<HTMLTag> oldHTMLTags, List<HTMLTag> newHTMLTags) {
        for (int index = 0; index < oldHTMLTags.size() && index < newHTMLTags.size(); ++index) {
            HTMLTag oldTag = oldHTMLTags.get(index);
            HTMLTag newTag = newHTMLTags.get(index);
            if (oldTag.getId().equals(newTag.getId())) continue;
            throw new IllegalArgumentException("different tag ids");
        }
    }

    public static boolean attributesAreEqualOrCanBeChangedLocally(HTMLTag oldHTMLTag, HTMLTag newHTMLTag, List<String> attributeChanges) {
        if (!oldHTMLTag.hasAttributes() && !newHTMLTag.hasAttributes()) {
            return true;
        }
        boolean attributeChangeMustBeFixedGlobally = XmlDiff.hasAnAttributeBeenDeleted(oldHTMLTag, newHTMLTag, attributeChanges);
        if (attributeChangeMustBeFixedGlobally) {
            return false;
        }
        HTMLAttribute newAttribute = null;
        HTMLAttribute oldAttribute = null;
        StringBuffer changeAttributes = new StringBuffer();
        String id = null;
        for (int i = 0; i < newHTMLTag.getAttributes().size(); ++i) {
            newAttribute = newHTMLTag.getAttributes().get(i);
            String newValue = String.valueOf(newAttribute.value);
            String attributeName = newAttribute.name;
            oldAttribute = oldHTMLTag.getAttribute(attributeName);
            if (null == oldAttribute) {
                if (newValue == null || newValue.length() <= 0) continue;
                changeAttributes.append("<attribute name=\"" + attributeName + "\" value=\"" + newValue + "\"/>");
                continue;
            }
            String oldString = String.valueOf(oldAttribute.value);
            if (attributeName.equals("id")) {
                id = oldString;
            }
            if (attributeName.equals("action") && oldString.contains("jsessionid")) {
                int start = oldString.indexOf(";jsessionid");
                int end = oldString.indexOf(";", start + 1);
                oldString = end > 0 ? oldString.substring(0, start) + oldString.substring(end) : oldString.substring(0, start);
            }
            if (oldString.equals(newValue)) continue;
            changeAttributes.append("<attribute name=\"" + attributeName + "\" value=\"" + newValue + "\"/>");
        }
        if (changeAttributes.length() > 0) {
            if (null != id && id.length() > 0) {
                String c = "<attributes id=\"" + id + "\">" + changeAttributes.toString() + "</attributes>";
                attributeChanges.add(c);
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean childHTMLTagsAreEqualOrCanBeChangedLocally(List<HTMLTag> oldHTMLTags, List<HTMLTag> newHTMLTags, List<HTMLTag> updates, List<String> deletions, List<String> attributeChanges, List<String> inserts) {
        boolean needsUpdate = false;
        ArrayList<String> localDeletions = new ArrayList<String>();
        ArrayList<String> localInserts = new ArrayList<String>();
        ArrayList<HTMLTag> localUpdates = new ArrayList<HTMLTag>();
        ArrayList<String> localAttributeChanges = new ArrayList<String>();
        List<HTMLTag> insertList = XmlDiff.getRecentlyAddedHTMLTags(oldHTMLTags = new ArrayList<HTMLTag>(oldHTMLTags), newHTMLTags = new ArrayList<HTMLTag>(newHTMLTags));
        if (insertList.size() > 0) {
            if (!BabbageConfiguration.isUseInsertStatements()) {
                needsUpdate = true;
            }
            needsUpdate |= XmlDiff.isThereANodeThatCannotBeInserted(insertList);
            if (oldHTMLTags.size() == 0) {
                needsUpdate = true;
            }
            if (!needsUpdate) {
                needsUpdate |= XmlDiff.generateInsertCommands(newHTMLTags, localInserts, insertList, localUpdates);
            }
        }
        if (!needsUpdate) {
            List<HTMLTag> deleteList = XmlDiff.getRecentlyAddedHTMLTags(newHTMLTags, oldHTMLTags);
            for (HTMLTag d : deleteList) {
                if (d.getId().isEmpty()) {
                    needsUpdate = true;
                    break;
                }
                localDeletions.add(d.getId());
                oldHTMLTags.remove(d);
            }
        }
        if (needsUpdate) {
            LOGGER.fine("HTMLTags contain different ids or descriptions, so they require update of parent.");
            return false;
        }
        XmlDiff.assertTagIDMatch(oldHTMLTags, newHTMLTags);
        int indexOld = 0;
        int indexNew = 0;
        while (indexOld < oldHTMLTags.size() && indexOld < newHTMLTags.size()) {
            HTMLTag newTag;
            HTMLTag oldTag = oldHTMLTags.get(indexOld);
            if (!XmlDiff.tagsAreEqualOrCanBeChangedLocally(oldTag, newTag = newHTMLTags.get(indexNew), localUpdates, localDeletions, localAttributeChanges, localInserts)) {
                LOGGER.fine("HTMLTags are different, require update of parent. Old HTMLTag:" + oldTag.getDescription() + " new HTMLTag: " + newTag.getDescription());
                if (oldTag.getId() != null && oldTag.getId().length() > 0) {
                    localUpdates.add(newTag);
                } else {
                    return false;
                }
            }
            ++indexOld;
            ++indexNew;
        }
        if (localDeletions.size() > 0) {
            LOGGER.fine("Adding HTMLTag deletions");
            deletions.addAll(localDeletions);
        }
        if (localInserts.size() > 0) {
            LOGGER.fine("Adding HTMLTag insertions");
            inserts.addAll(localInserts);
        }
        if (localUpdates.size() > 0) {
            LOGGER.fine("Adding HTMLTag update");
            updates.addAll(localUpdates);
        }
        if (localAttributeChanges.size() > 0) {
            LOGGER.fine("Adding HTMLTag attribute");
            attributeChanges.addAll(localAttributeChanges);
        }
        return true;
    }

    private static boolean generateInsertCommands(List<HTMLTag> newHTMLTags, List<String> inserts, List<HTMLTag> insertList, List<HTMLTag> updates) {
        block0: for (HTMLTag insert : insertList) {
            HTMLTag parent = insert.getParent();
            for (int index = 0; index < parent.getChildren().size(); ++index) {
                String idOfSibling;
                HTMLTag sibling = parent.getChildren().get(index);
                if (insert != sibling) continue;
                String idOfNewTag = insert.getId();
                String temporaryDiv = "<div id=\"" + idOfNewTag + "\" />";
                String s = null;
                boolean isScriptNode = false;
                int offset = 1;
                while (index - offset >= 0 && "script".equals(parent.getChildren().get(index - offset).getNodeName())) {
                    if (index - ++offset >= 0) continue;
                    isScriptNode = true;
                    break;
                }
                if (!isScriptNode && index - offset >= 0 && null != (idOfSibling = parent.getChildren().get(index - offset).getId()) && idOfSibling.length() > 0) {
                    s = "<insert id=\"" + idOfNewTag + "\"><after id=\"" + idOfSibling + "\"><![CDATA[" + temporaryDiv + "]]></after></insert>";
                }
                if (null == s) {
                    offset = 1;
                    while (index + offset < parent.getChildren().size() && "script".equals(parent.getChildren().get(index + offset).getNodeName())) {
                        if (index + ++offset < parent.getChildren().size()) continue;
                        return true;
                    }
                    if (index + offset >= parent.getChildren().size()) {
                        return true;
                    }
                    idOfSibling = parent.getChildren().get(index + offset).getId();
                    if (null == idOfSibling || idOfSibling.length() == 0) {
                        return true;
                    }
                    s = "<insert id=\"" + idOfNewTag + "\"><before id=\"" + idOfSibling + "\"><![CDATA[" + temporaryDiv + "]]></before></insert>";
                }
                inserts.add(s);
                updates.add(insert);
                newHTMLTags.remove(insert);
                continue block0;
            }
        }
        return false;
    }

    private static List<HTMLTag> getNonEmptyHTMLTags(List<HTMLTag> tags) {
        ArrayList<HTMLTag> nonEmpty = new ArrayList<HTMLTag>();
        for (int i = 0; i < tags.size(); ++i) {
            HTMLTag n = tags.get(i);
            if (n.hasAttributes() || n.getChildren().size() > 0 || n.getNodeName() != null && n.getNodeName().length() > 0 || n.getInnerHTML().toString().trim().length() > 0) {
                if (n.hasAttributes() && n.getAttribute("name") != null) {
                    if (n.getAttribute((String)"name").value.equals("javax.faces.ViewState")) continue;
                    nonEmpty.add(n);
                    continue;
                }
                nonEmpty.add(n);
                continue;
            }
            LOGGER.severe("Empty tag!");
        }
        return nonEmpty;
    }

    public static List<HTMLTag> getRecentlyAddedHTMLTags(List<HTMLTag> oldHTMLTags, List<HTMLTag> newHTMLTags) {
        String desc;
        HTMLTag n;
        int i;
        ArrayList<HTMLTag> result = new ArrayList<HTMLTag>();
        HashMap<String, HTMLTag> alreadyThere = new HashMap<String, HTMLTag>();
        for (i = 0; i < oldHTMLTags.size(); ++i) {
            n = oldHTMLTags.get(i);
            desc = n.getDescription();
            alreadyThere.put(desc, n);
        }
        for (i = 0; i < newHTMLTags.size(); ++i) {
            n = newHTMLTags.get(i);
            desc = n.getDescription();
            if (alreadyThere.containsKey(desc)) continue;
            result.add(n);
        }
        return result;
    }

    private static boolean hasAnAttributeBeenDeleted(HTMLTag oldHTMLTag, HTMLTag newHTMLTag, List<String> changes) {
        HTMLAttribute newAttribute = null;
        HTMLAttribute oldAttribute = null;
        for (int i = 0; i < oldHTMLTag.getAttributes().size(); ++i) {
            oldAttribute = oldHTMLTag.getAttributes().get(i);
            String attributeName = oldAttribute.name;
            newAttribute = newHTMLTag.getAttribute(attributeName);
            if (null != newAttribute) continue;
            if (newHTMLTag.getId() != null && newHTMLTag.getId().length() > 0) {
                String s = "<eval><![CDATA[document.getElementById('" + newHTMLTag.getId() + "').removeAttribute('" + attributeName + "');]]></eval>";
                changes.add(s);
                continue;
            }
            return true;
        }
        return false;
    }

    private static boolean isThereANodeThatCannotBeInserted(List<HTMLTag> insertList) {
        boolean needsUpdate = false;
        for (HTMLTag insert : insertList) {
            if (!insert.getId().isEmpty()) continue;
            needsUpdate = true;
            break;
        }
        return needsUpdate;
    }

    public static boolean tagsAreEqualOrCanBeChangedLocally(HTMLTag oldHTMLTag, HTMLTag newHTMLTag, List<HTMLTag> updates, List<String> deletions, List<String> attributeChanges, List<String> inserts) {
        String c;
        List<HTMLTag> newHTMLTags;
        if (!oldHTMLTag.getNodeName().equals(newHTMLTag.getNodeName())) {
            return false;
        }
        if (!oldHTMLTag.getId().equals(newHTMLTag.getId())) {
            return false;
        }
        if (!XmlDiff.areStringsEqualOrCanBeChangedLocally(oldHTMLTag.getInnerHTML().toString(), newHTMLTag.getInnerHTML().toString())) {
            return false;
        }
        ArrayList<String> localDeletions = new ArrayList<String>();
        ArrayList<String> localInserts = new ArrayList<String>();
        ArrayList<HTMLTag> localUpdates = new ArrayList<HTMLTag>();
        ArrayList<String> localAttributeChanges = new ArrayList<String>();
        if (!XmlDiff.attributesAreEqualOrCanBeChangedLocally(oldHTMLTag, newHTMLTag, localAttributeChanges)) {
            LOGGER.fine("Attributes are so different that they require update of parent. Old HTMLTag:" + oldHTMLTag.getDescription() + " new HTMLTag: " + newHTMLTag.getDescription());
            return false;
        }
        List<HTMLTag> oldHTMLTags = XmlDiff.getNonEmptyHTMLTags(oldHTMLTag.getChildren());
        boolean childHTMLTagsHaveChangedAndRequireGlobalUpdate = false == XmlDiff.childHTMLTagsAreEqualOrCanBeChangedLocally(oldHTMLTags, newHTMLTags = XmlDiff.getNonEmptyHTMLTags(newHTMLTag.getChildren()), localUpdates, localDeletions, attributeChanges, localInserts);
        HTMLAttribute classAttribute = newHTMLTag.getAttribute("class");
        if (null != classAttribute && (c = classAttribute.value).contains("ui-selectonemenu ") && 0 < localUpdates.size() + localDeletions.size() + localInserts.size()) {
            LOGGER.info("The combobox seems to have changed. Updating the inner structure isn't reliable enough. I exchange the widget as a whole.");
            return false;
        }
        if (childHTMLTagsHaveChangedAndRequireGlobalUpdate) {
            if (null == newHTMLTag.getId()) {
                return false;
            }
            updates.add(newHTMLTag);
        } else {
            if (localAttributeChanges.size() > 0) {
                attributeChanges.addAll(localAttributeChanges);
            }
            if (localInserts.size() > 0) {
                inserts.addAll(localInserts);
            }
            if (localUpdates.size() > 0) {
                updates.addAll(localUpdates);
            }
            if (localDeletions.size() > 0) {
                deletions.addAll(localDeletions);
            }
        }
        return true;
    }
}

