/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.jsf.ajax.differentialContextWriter.differenceEngine;

import de.beyondjava.jsf.ajax.differentialContextWriter.differenceEngine.BabbageConfiguration;
import de.beyondjava.jsf.ajax.differentialContextWriter.differenceEngine.XmlDiff;
import de.beyondjava.jsf.ajax.differentialContextWriter.parser.HTMLAttribute;
import de.beyondjava.jsf.ajax.differentialContextWriter.parser.HTMLTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;

public class DifferenceEngine {
    private static long DEBUG_optimizedBytesCumulated = 0L;
    private static long DEBUG_originalBytesCumulated = 0L;
    private static boolean differentialEngineActive = true;
    public static final String DISPLAY_STATISTICS = "com.beyondjava.babbageFaces.displayStatistics";
    static final String LAST_KNOWN_HTML_KEY = "com.beyondEE.faces.diff.lastKnownHTML";
    private static final Logger LOGGER = Logger.getLogger("de.beyondjava.jsf.ajax.differentialContextWriter.differenceEngine.DiffenceEngine");
    final boolean isDeveloperMode = FacesContext.getCurrentInstance() != null && FacesContext.getCurrentInstance().getApplication().getProjectStage() == ProjectStage.Development;

    private String addStatisticsToAJAXResponse(String currentResponse, Map<String, Object> sessionMap, boolean isAJAX, int originalUpdates, int originalOtherTags, int originalErrorTags, int optimizedUpdates, int optimizedInserts, int optimizedDeletes, int optimizedAttributes, int originalLength, int optimizedLength) {
        if (isAJAX) {
            if (this.isDeveloperMode) {
                int pos = currentResponse.indexOf("<div id=\"babbageFacesStatistics\"></div>");
                if (pos > 0) {
                    sessionMap.put(DISPLAY_STATISTICS, "true");
                }
                if (sessionMap.containsKey(DISPLAY_STATISTICS)) {
                    String responseMessage = "<table><tr><td></td><td ><b>Original response</b></td><td><b>Optimized response</b></td></tr><tr><td>Size:</td><td>" + originalLength + " bytes</td><td> " + optimizedLength + " bytes</td><td>" + 100 * optimizedLength / originalLength + "%</td></tr>";
                    responseMessage = responseMessage + "<tr><td>total </td><td> " + DEBUG_originalBytesCumulated + "</td><td> " + DEBUG_optimizedBytesCumulated;
                    responseMessage = responseMessage + "</td><td>" + 100L * DEBUG_optimizedBytesCumulated / DEBUG_originalBytesCumulated + "% </tr><tr><td>";
                    responseMessage = responseMessage + "updates:</td><td> " + originalUpdates;
                    responseMessage = responseMessage + "</td><td>" + optimizedUpdates + "</td></tr>";
                    responseMessage = responseMessage + "<tr><td>inserts:</td><td></td><td> " + optimizedInserts + "</td></tr>";
                    responseMessage = responseMessage + "<tr><td>deletes:</td><td></td><td> " + optimizedDeletes + "</td></tr>";
                    responseMessage = responseMessage + "<tr><td>attributes:</td><td></td><td> " + optimizedAttributes + "</td></tr>";
                    responseMessage = responseMessage + "<tr><td>Original error tags</td><td>" + originalErrorTags + "</td></tr>";
                    responseMessage = responseMessage + "<tr><td>other original tags</td><td>" + originalOtherTags + "</td></tr></table>";
                    pos = currentResponse.indexOf("</changes>");
                    if (pos > 0) {
                        currentResponse = currentResponse.substring(0, pos) + "<update id=\"babbageFacesStatistics\"><![CDATA[<div id=\"babbageFacesStatistics\">" + responseMessage + "</div>]]></update>" + currentResponse.substring(pos);
                    }
                }
            }
        } else if (this.isDeveloperMode) {
            String responseMessage = "HTML - original response:  " + originalLength + " bytes  Optimized response: " + optimizedLength + " bytes  total original: " + DEBUG_originalBytesCumulated + "  total optimized: " + DEBUG_optimizedBytesCumulated;
            LOGGER.info(responseMessage);
        }
        return currentResponse;
    }

    private String addStatisticsToNonAJAXResponse(String currentResponse, Map<String, Object> sessionMap, int originalLength, HTMLTag responseWithAdditionalIDs) {
        if (this.isDeveloperMode) {
            int pos;
            String body = responseWithAdditionalIDs.getChildren().get(1).toString();
            int bodyIndex = currentResponse.indexOf("<body>");
            if (bodyIndex < 0) {
                bodyIndex = currentResponse.indexOf("<body ");
            }
            int bodyEndIndex = currentResponse.indexOf("</body>");
            if (bodyIndex > 0 && bodyEndIndex > 0) {
                currentResponse = currentResponse.substring(0, bodyIndex) + "\n<!-- Optimized by BabbageFaces, an AngularFaces subproject -->\n" + body + currentResponse.substring(bodyEndIndex + "</body>".length());
            }
            if ((pos = currentResponse.indexOf("<div id=\"babbageFacesStatistics\"></div>")) > 0) {
                sessionMap.put(DISPLAY_STATISTICS, "true");
                currentResponse = currentResponse.substring(0, pos += "<div id=\"babbageFacesStatistics\">".length()) + "Non-AJAX response - nothing to optimize.<br />" + "Original response:  " + originalLength + "<br />" + "Optimized response: " + currentResponse.length() + "<br />" + "(usually bigger because the HMTL code is reformatted and lots of ids have to be inserted to make BabbabgeFaces smoother)" + currentResponse.substring(pos);
            }
        }
        return currentResponse;
    }

    private List<HTMLTag> determineNecessaryChangeFromResponse(HTMLTag change, HTMLTag lastKnownDOMTree) {
        if (change.getNodeName().equals("update")) {
            String id = change.getId();
            HTMLTag changingHTML = change.getFirstChild().isCDATANode() || change.getFirstChild().isTextNode() ? new HTMLTag(change.getFirstChild().getInnerHTML().toString().trim()) : new HTMLTag(change.getFirstChild().toString().trim());
            HTMLTag lastKnownCorrespondingHTMLTag = lastKnownDOMTree.findByID(id);
            if (null == lastKnownCorrespondingHTMLTag) {
                LOGGER.severe(lastKnownDOMTree.toString());
                LOGGER.severe("Couldn't find id " + id + " in the last known DOM tree");
                throw new IllegalArgumentException("Couldn't find id " + id + " in the last known DOM tree");
            }
            return this.determineNecessaryChanges(changingHTML, lastKnownCorrespondingHTMLTag);
        }
        LOGGER.fine(change.getNodeName() + " - remains unchanged");
        return null;
    }

    private List<HTMLTag> determineNecessaryChanges(HTMLTag changingHTML, HTMLTag lastKnownCorrespondingHTMLTag) {
        ArrayList<String> deletions = new ArrayList<String>();
        ArrayList<String> attributeChanges = new ArrayList<String>();
        ArrayList<String> inserts = new ArrayList<String>();
        ArrayList<HTMLTag> updates = new ArrayList<HTMLTag>();
        this.determineNecessaryChanges(changingHTML, lastKnownCorrespondingHTMLTag, updates, deletions, attributeChanges, inserts);
        ArrayList<HTMLTag> partialChanges = new ArrayList<HTMLTag>();
        if (null != inserts && inserts.size() > 0) {
            for (String insert : inserts) {
                partialChanges.add(new HTMLTag(insert));
            }
        }
        if (null != deletions) {
            for (String partialID : deletions) {
                String partialChange = "<delete id=\"" + partialID + "\"/>";
                HTMLTag partialChangeHTMLTag = new HTMLTag(partialChange);
                partialChanges.add(partialChangeHTMLTag);
            }
        }
        if (null != updates) {
            for (HTMLTag n : updates) {
                n = this.findNodeThatCanBeReplaced(n);
                String partialUpdate = n.toCompactString();
                String partialID = n.getId();
                HTMLTag partialChangeHTMLTag = new HTMLTag("update", partialID, partialUpdate);
                partialChanges.add(partialChangeHTMLTag);
            }
        }
        if (null != attributeChanges) {
            for (String partialChange : attributeChanges) {
                HTMLTag partialChangeHTMLTag = new HTMLTag(partialChange);
                partialChanges.add(partialChangeHTMLTag);
            }
        }
        return partialChanges;
    }

    protected List<HTMLTag> determineNecessaryChanges(HTMLTag newDOM, HTMLTag lastKnownCorrespondingHTMLTag, List<HTMLTag> updates, List<String> deletions, List<String> attributeChanges, List<String> inserts) {
        XmlDiff.tagsAreEqualOrCanBeChangedLocally(lastKnownCorrespondingHTMLTag, newDOM, updates, deletions, attributeChanges, inserts);
        for (HTMLTag hTMLTag : updates) {
            if (!this.isDeveloperMode) continue;
            LOGGER.fine("Updates: " + hTMLTag);
        }
        for (String string : deletions) {
            if (!this.isDeveloperMode) continue;
            LOGGER.fine("Deletion: " + string);
        }
        for (String string : attributeChanges) {
            if (!this.isDeveloperMode) continue;
            LOGGER.fine("Change: " + string);
        }
        for (String string : inserts) {
            if (!this.isDeveloperMode) continue;
            LOGGER.fine("Insertion: " + string);
        }
        return updates;
    }

    private void exciseScriptsFromUpdateCommand(Map<String, String> scriptsToBeAdded, StringBuffer replacement, HTMLTag changeDefinition) {
        int scriptTagStart;
        String c = changeDefinition.toCompactString();
        boolean isPureJSTag = false;
        while ((scriptTagStart = c.indexOf("<script id=\"")) > 0) {
            int scriptIDStart = scriptTagStart + "<script id=\"".length();
            int scriptIDEnd = c.indexOf("\"", scriptIDStart + 1);
            if (scriptIDEnd <= 0) continue;
            int scriptStart = c.indexOf("\">", scriptIDEnd + 1);
            int scriptEnd = c.indexOf("</script>", scriptStart);
            if (scriptStart <= 0 || scriptEnd <= 0) continue;
            scriptsToBeAdded.put(c.substring(scriptIDStart, scriptIDEnd), c.substring(scriptStart + 2, scriptEnd));
            if (!(c = c.substring(0, scriptTagStart) + c.substring(scriptEnd + "</script>".length())).contains("<![CDATA[]]>")) continue;
            isPureJSTag = true;
        }
        if (!isPureJSTag) {
            replacement.append(c);
        }
    }

    private List<HTMLTag> extractChangesFromPartialResponse(String partialResponse) throws Exception {
        ArrayList<HTMLTag> partialResponses = new ArrayList<HTMLTag>();
        partialResponse = partialResponse.replace("\n", "").replace("\r", "");
        Pattern pattern = Pattern.compile("(<update id=\".*?\">.*?</update>)|(<attributes id=\".*?\">.*?</attributes>)|(<delete id=\".*?\">.*?</update>)|(<eval>.*</eval>)|(<insert id=\".*?\\\">.*?</insert>)|(<extension ?.>.*?</extension>)|(<error>.*</error>)|(<redirect url=\".*?\">.*?</redirect>)");
        Matcher matcher = pattern.matcher(partialResponse);
        while (matcher.find()) {
            String group = matcher.group();
            if (group.startsWith("<update")) {
                int start = "<update id=\"".length();
                int end = group.indexOf(34, start);
                if (end > start) {
                    String id = group.substring(start, end);
                    start = group.indexOf("<![CDATA[", end);
                    end = group.lastIndexOf("]]>");
                    if (start >= 0 && end > start) {
                        String html = group.substring(start + "<![CDATA[".length(), end);
                        try {
                            HTMLTag update = new HTMLTag("<update id=\"" + id + "\">" + html + "</update>");
                            partialResponses.add(update);
                            continue;
                        }
                        catch (Exception invalidXML) {
                            LOGGER.severe("One of the update statements in the response contains invalid XHTML code!");
                            LOGGER.severe("ID = " + id);
                            throw invalidXML;
                        }
                    }
                    partialResponses.add(new HTMLTag(group));
                    continue;
                }
                partialResponses.add(new HTMLTag(group));
                continue;
            }
            partialResponses.add(new HTMLTag(group));
        }
        return partialResponses;
    }

    private HTMLTag findNodeThatCanBeReplaced(HTMLTag n) {
        HTMLTag grandpa;
        HTMLAttribute c;
        if ("select".equals(n.getNodeName()) && n.getParent() != null && n.getParent().getParent() != null && (c = (grandpa = n.getParent().getParent()).getAttribute("class")) != null && c.value.contains("ui-selectonemenu")) {
            n = grandpa;
        }
        while (n.getId() == null || n.getId().length() == 0) {
            if (n.getParent() == null) {
                LOGGER.severe("ID of update shouldn't be void - can't be fixed because parent tag is null");
            } else {
                LOGGER.severe("ID of update shouldn't be void - using the parent instead");
            }
            if (this.isDeveloperMode) {
                LOGGER.fine(n.toCompactString());
            }
            n = n.getParent();
        }
        return n;
    }

    private boolean isRegularUpdateCommand(HTMLTag change) {
        if (change.getChildren().size() != 1) {
            return false;
        }
        return change.getFirstChild().getId() != null && !"".equals(change.getFirstChild().getId());
    }

    private String optimizeResponse(String currentResponse, HTMLTag domTreeToBeUpdated, HTMLTag change, List<HTMLTag> newPartialChanges) {
        String id = change.getId();
        return this.optimizeResponse(currentResponse, domTreeToBeUpdated, newPartialChanges, id);
    }

    private String optimizeResponse(String currentResponse, HTMLTag domTreeToBeUpdated, List<HTMLTag> newPartialChanges, String id) {
        if (!id.contains("javax.faces.ViewState")) {
            HashMap<String, String> scriptsToBeAdded = new HashMap<String, String>();
            Map<String, HTMLTag> scriptsInOriginalDomTree = domTreeToBeUpdated.collectScripts();
            int start = currentResponse.indexOf("<update id=\"" + id + "\">");
            int end = currentResponse.indexOf("</update>", start);
            int lengthOfOriginalCommand = end + "</update>".length() - start;
            String currentResponseEnd = currentResponse.substring(end + "</update>".length());
            String currentResponseStart = currentResponse.substring(0, start);
            StringBuffer replacement = new StringBuffer();
            for (HTMLTag changeDefinition : newPartialChanges) {
                HTMLTag currentChangeTag;
                this.exciseScriptsFromUpdateCommand(scriptsToBeAdded, replacement, changeDefinition);
                String idOfCurrentChange = changeDefinition.getId();
                if (idOfCurrentChange == null || idOfCurrentChange.length() == 0) {
                    if ("eval".equals(changeDefinition.getNodeName())) continue;
                    LOGGER.severe("Missing HTMLTag ID");
                    continue;
                }
                if (!changeDefinition.getNodeName().equals("update") || null == (currentChangeTag = domTreeToBeUpdated.findByID(idOfCurrentChange))) continue;
                Collection<HTMLTag> requiredScripts = currentChangeTag.extractPrimeFacesJavascript(scriptsInOriginalDomTree);
                for (HTMLTag scriptNode : requiredScripts) {
                    if (scriptsToBeAdded.containsKey(scriptNode.getId())) continue;
                    scriptsToBeAdded.put(scriptNode.getId(), scriptNode.getFirstChild().toCompactString());
                }
            }
            if (!scriptsToBeAdded.isEmpty()) {
                replacement.append("<eval><![CDATA[");
                for (String currentScript : scriptsToBeAdded.values()) {
                    replacement.append(currentScript);
                    replacement.append(";");
                }
                replacement.append("]]></eval>");
            }
            if (replacement.length() < lengthOfOriginalCommand || !BabbageConfiguration.isOptimizeSize()) {
                currentResponse = currentResponseStart + replacement.toString() + currentResponseEnd;
            } else {
                String originalUpdateString = currentResponse.substring(start, end + "</update>".length());
                HTMLTag originalUpdate = new HTMLTag(originalUpdateString);
                HTMLTag cdata = originalUpdate.getFirstChild();
                String htmlWithIDsString = new HTMLTag(cdata.getInnerHTML().toString()).toCompactString();
                cdata.setInnerHTML(new StringBuffer(htmlWithIDsString));
                String optimizedUpdateString = cdata.toCompactString();
                currentResponse = replacement.length() < optimizedUpdateString.length() ? currentResponseStart + replacement.toString() + currentResponseEnd : currentResponseStart + optimizedUpdateString + currentResponseEnd;
            }
        }
        return currentResponse;
    }

    private HTMLTag retrieveLastKnownHTMLFromSession(Map<String, Object> sessionMap) {
        HTMLTag html = (HTMLTag)sessionMap.get(LAST_KNOWN_HTML_KEY);
        if (html == null) {
            throw new RuntimeException("There's no HTML code stored in the session");
        }
        return html;
    }

    private void updateHTMLTag(HTMLTag domTreeInSession, HTMLTag newSubtree, String idToBeUpdated) {
        HTMLTag tagToBeReplaced = domTreeInSession.findByID(idToBeUpdated);
        if (tagToBeReplaced == null) {
            if (!idToBeUpdated.contains("javax.faces.ViewState")) {
                LOGGER.severe("Wrong ID? Looking for " + idToBeUpdated + ", but couldn't find the ID in the last known HTML tree");
            }
        } else {
            HTMLTag parentHTMLTag;
            if (newSubtree.isCDATANode()) {
                newSubtree = new HTMLTag(newSubtree.getInnerHTML().toString());
            }
            if ((parentHTMLTag = tagToBeReplaced.getParent()) == null) {
                LOGGER.severe("parent HTML tag = null: did you try to replace the whole tree?" + tagToBeReplaced.getId());
            } else {
                parentHTMLTag.replaceChild(newSubtree, tagToBeReplaced);
            }
        }
    }

    public String yieldDifferences(String currentResponse, Map<String, Object> sessionMap, boolean isAJAX) throws Exception {
        int originalUpdates = 0;
        int originalOtherTags = 0;
        int originalErrorTags = 0;
        int optimizedUpdates = 0;
        int optimizedInserts = 0;
        int optimizedDeletes = 0;
        int optimizedAttributes = 0;
        int originalLength = currentResponse.length();
        if (!differentialEngineActive) {
            System.out.println(currentResponse);
            return currentResponse;
        }
        if (isAJAX) {
            HTMLTag domTreeToBeUpdated = this.retrieveLastKnownHTMLFromSession(sessionMap);
            List<HTMLTag> listOfChanges = this.extractChangesFromPartialResponse(currentResponse);
            for (HTMLTag change : listOfChanges) {
                if (change.getNodeName().equals("update")) {
                    ++originalUpdates;
                    if (change.getId().equals("javax.faces.ViewRoot")) {
                        String oldHeaderAsString;
                        HTMLTag newDom = change;
                        HTMLTag header = newDom.findTag("head");
                        HTMLTag body = newDom.findTag("body");
                        int endOfFirstUpdate = currentResponse.indexOf("</update>");
                        String secondUpdate = currentResponse.substring(endOfFirstUpdate);
                        String s = "<?xml version='1.0' encoding='UTF-8'?>\r\n<partial-response id=\"j_id1\"><changes>";
                        HTMLTag oldHeader = domTreeToBeUpdated.findTag("head");
                        String headerAsString = header.toCompactString();
                        if (!headerAsString.equals(oldHeaderAsString = oldHeader.toCompactString())) {
                            int startNew = headerAsString.indexOf("<title>");
                            int endNew = headerAsString.indexOf("</title>");
                            String title = "";
                            if (startNew >= 0 && endNew >= 0) {
                                title = headerAsString.substring(startNew + "<title>".length(), endNew);
                                headerAsString = headerAsString.substring(0, startNew) + headerAsString.substring(endNew);
                            }
                            int startOld = oldHeaderAsString.indexOf("<title>");
                            int endOld = oldHeaderAsString.indexOf("</title>");
                            if (startOld >= 0 && endNew >= 0) {
                                oldHeaderAsString = oldHeaderAsString.substring(0, startOld) + oldHeaderAsString.substring(endOld);
                            }
                            if (headerAsString.equals(oldHeaderAsString)) {
                                s = s + "<eval><![CDATA[window.document.title='" + title + "';" + "]]></eval>";
                                ++optimizedAttributes;
                            } else {
                                s = s + "<update id=\"javax.faces.ViewHead\"><![CDATA[" + headerAsString + "]]></update>";
                                ++optimizedUpdates;
                            }
                        }
                        s = s + "<update id=\"javax.faces.ViewBody\"><![CDATA[" + body.toCompactString() + "]]>";
                        currentResponse = s = s + secondUpdate;
                        List<HTMLTag> newBodyChanges = this.determineNecessaryChanges(body, domTreeToBeUpdated.findTag("body"));
                        for (HTMLTag t : newBodyChanges) {
                            if ("update".equals(t.getNodeName())) {
                                ++optimizedUpdates;
                                continue;
                            }
                            if ("insert".equals(t.getNodeName())) {
                                ++optimizedInserts;
                                continue;
                            }
                            if ("delete".equals(t.getNodeName())) {
                                ++optimizedDeletes;
                                continue;
                            }
                            if (!"attribute".equals(t.getNodeName())) continue;
                            ++optimizedAttributes;
                        }
                        currentResponse = this.optimizeResponse(currentResponse, domTreeToBeUpdated, newBodyChanges, "javax.faces.ViewBody");
                        domTreeToBeUpdated = newDom;
                        sessionMap.remove(LAST_KNOWN_HTML_KEY);
                        sessionMap.put(LAST_KNOWN_HTML_KEY, newDom);
                        continue;
                    }
                    if (change.getId().contains("javax.faces.ViewState") || change.getId().contains("javax.faces.ViewHead") || change.getId().contains("javax.faces.ViewBody") || !this.isRegularUpdateCommand(change)) continue;
                    List<HTMLTag> newPartialChanges = this.determineNecessaryChangeFromResponse(change, domTreeToBeUpdated);
                    if (null != newPartialChanges) {
                        currentResponse = this.optimizeResponse(currentResponse, domTreeToBeUpdated, change, newPartialChanges);
                        for (HTMLTag t : newPartialChanges) {
                            if ("update".equals(t.getNodeName())) {
                                ++optimizedUpdates;
                                continue;
                            }
                            if ("insert".equals(t.getNodeName())) {
                                ++optimizedInserts;
                                continue;
                            }
                            if ("delete".equals(t.getNodeName())) {
                                ++optimizedDeletes;
                                continue;
                            }
                            if (!"attribute".equals(t.getNodeName())) continue;
                            ++optimizedAttributes;
                        }
                    }
                    this.updateHTMLTag(domTreeToBeUpdated, change.getFirstChild(), change.getId());
                    continue;
                }
                if (!"error-name".equals(change.getNodeName()) && !"error-message".equals(change.getNodeName())) {
                    LOGGER.severe("Unexpected JSF response (" + change.getNodeName() + ")");
                    ++originalOtherTags;
                    continue;
                }
                ++originalErrorTags;
            }
        } else {
            HTMLTag responseWithAdditionalIDs = new HTMLTag(currentResponse);
            sessionMap.remove(LAST_KNOWN_HTML_KEY);
            sessionMap.put(LAST_KNOWN_HTML_KEY, responseWithAdditionalIDs);
            currentResponse = this.addStatisticsToNonAJAXResponse(currentResponse, sessionMap, originalLength, responseWithAdditionalIDs);
        }
        int optimizedLength = currentResponse.length();
        DEBUG_optimizedBytesCumulated += (long)optimizedLength;
        DEBUG_originalBytesCumulated += (long)originalLength;
        currentResponse = this.addStatisticsToAJAXResponse(currentResponse, sessionMap, isAJAX, originalUpdates, originalOtherTags, originalErrorTags, optimizedUpdates, optimizedInserts, optimizedDeletes, optimizedAttributes, originalLength, optimizedLength);
        return currentResponse;
    }
}

