/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.jsf.ajax.differentialContextWriter;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Logger;

public class PrettyPrintResponseWriter
extends Writer {
    private static final Logger LOGGER = Logger.getLogger("de.beyondjava.jsf.ajax.differentialContextWriter.PrettyPrintResponseWriter");
    boolean almostFinished = false;
    boolean finished = false;
    private int indent = 0;
    private StringBuffer prettyBuffer = new StringBuffer();
    private StringBuffer rawBuffer = new StringBuffer();
    private Writer sunWriter;

    public PrettyPrintResponseWriter(Writer writer) {
        this.sunWriter = writer;
    }

    @Override
    public void close() throws IOException {
        this.sunWriter.write(this.rawBuffer.toString());
        this.sunWriter.close();
        this.rawBuffer.setLength(0);
    }

    @Override
    public void flush() throws IOException {
        this.sunWriter.write(this.rawBuffer.toString());
        this.sunWriter.flush();
        this.rawBuffer.setLength(0);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (cbuf[off] == '\n') {
            ++off;
            --len;
        }
        String s = new String(cbuf, off, len);
        this.rawBuffer.append(s);
        while (s.contains("><")) {
            int pos = s.indexOf("><");
            String first = s.substring(0, pos + 1);
            s = s.substring(pos + 1);
            this.writeASingleTag(first);
        }
        this.writeASingleTag(s);
    }

    private void writeASingleTag(String s) throws IOException {
        int fin;
        if (s.startsWith("<")) {
            if (s.startsWith("</")) {
                --this.indent;
            }
            if ((fin = this.prettyBuffer.length() - 1) >= 0) {
                if (this.prettyBuffer.charAt(fin) != '\n') {
                    this.prettyBuffer.append("\n");
                }
                for (int i = 0; i < this.indent; ++i) {
                    this.prettyBuffer.append("    ");
                }
            }
            if (!(s.startsWith("</") || s.startsWith("<?") || s.startsWith("<!") || s.contains("/>"))) {
                ++this.indent;
            }
        } else if (s.contains("/>")) {
            --this.indent;
        }
        if (this.almostFinished) {
            this.finished = true;
        }
        if ((fin = this.prettyBuffer.length() - 1) >= 50) {
            if (s.contains("partial-response")) {
                this.almostFinished = true;
            }
            if (s.contains("</body>")) {
                this.finished = true;
            }
        }
        this.prettyBuffer.append(s);
        if (this.finished) {
            this.sunWriter.write(this.rawBuffer.toString());
            this.rawBuffer.setLength(0);
            this.sunWriter.append("\r\n<!--\r\n");
            this.sunWriter.write(this.prettyBuffer.toString());
            this.sunWriter.append("\r\n-->");
            this.prettyBuffer.setLength(0);
        }
    }
}

