/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.jsf.ajax.differentialContextWriter;

import de.beyondjava.jsf.ajax.differentialContextWriter.differenceEngine.BabbageConfiguration;
import de.beyondjava.jsf.ajax.differentialContextWriter.differenceEngine.DifferenceEngine;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import org.xml.sax.SAXParseException;

public class DiffentialResponseWriter
extends Writer {
    private static long DEBUG_timerCumulated = 0L;
    private static long DEBUG_totalTimeCumulated = 0L;
    private static final Logger LOGGER = Logger.getLogger("de.beyondjava.jsf.ajax.differentialContextWriter.DiffentialResponseWriter");
    boolean almostFinished = false;
    private boolean containsHTMLTag = false;
    boolean DEBUG_Finished = false;
    private long DEBUG_timer = 0L;
    private long DEBUG_totalTimeStart = 0L;
    private boolean disabledAfterError = false;
    boolean isAJAX = false;
    final boolean isDeveloperMode = FacesContext.getCurrentInstance().getApplication().getProjectStage() == ProjectStage.Development;
    private StringBuffer rawBuffer = new StringBuffer();
    private boolean rawbufferValid = true;
    private Map<String, Object> sessionMap;
    private Writer sunWriter;

    public DiffentialResponseWriter(Writer writer, Map<String, Object> sessionMap) {
        this.sunWriter = writer;
        this.sessionMap = sessionMap;
        this.DEBUG_timer = 0L;
        this.DEBUG_totalTimeStart = System.nanoTime();
        this.containsHTMLTag = false;
    }

    private void analyzeAndOptimizeResponse(long DEBUG_StartTime) throws IOException {
        this.DEBUG_Finished = true;
        if (this.rawbufferValid) {
            try {
                long DEBUG_OptimizationTime = System.nanoTime();
                String optimizedResponse = new DifferenceEngine().yieldDifferences(this.rawBuffer.toString(), this.sessionMap, this.isAJAX);
                optimizedResponse = this.logStatistics(DEBUG_StartTime, DEBUG_OptimizationTime, optimizedResponse);
                this.sunWriter.write(optimizedResponse);
            }
            catch (Exception anyError) {
                if (!(anyError.getCause() instanceof SAXParseException)) {
                    LOGGER.severe("An error occured when optimizing the AJAX response. I'll use the original response instead.");
                    LOGGER.severe(anyError.toString());
                    anyError.printStackTrace();
                }
                this.sunWriter.write(this.rawBuffer.toString());
                this.disabledAfterError = true;
            }
        } else {
            this.sunWriter.write(this.rawBuffer.toString());
        }
        this.rawBuffer.setLength(0);
    }

    @Override
    public void close() throws IOException {
        this.sunWriter.write(this.rawBuffer.toString());
        this.sunWriter.close();
        this.rawBuffer.setLength(0);
    }

    private boolean endOfPage(String s) {
        int start;
        if (!this.isAJAX && s.contains("partial-response")) {
            this.isAJAX = true;
        }
        if (!this.isAJAX && !this.containsHTMLTag && this.rawBuffer.indexOf("<html", start = this.rawBuffer.length() - s.length() - "<html".length()) > 0) {
            this.containsHTMLTag = true;
        }
        if (BabbageConfiguration.isMyFaces) {
            return false;
        }
        boolean finished = false;
        int fin = this.rawBuffer.length() - 1;
        if (this.almostFinished) {
            finished = true;
        } else if (fin > 20 && this.rawBuffer.charAt(fin - "partial-response".length()) == '/' && this.rawBuffer.charAt(fin - "partial-response".length() - 1) == '<' && s.contains("partial-response") && this.rawBuffer.lastIndexOf("<![CDATA[") < this.rawBuffer.lastIndexOf("]]>")) {
            this.almostFinished = true;
            this.isAJAX = true;
        }
        if (!this.isAJAX) {
            if (this.containsHTMLTag) {
                int start2 = this.rawBuffer.length() - s.length() - "</html>".length();
                if (this.rawBuffer.indexOf("</html>", start2) > 0) {
                    if (this.rawBuffer.lastIndexOf("<![CDATA[") > this.rawBuffer.lastIndexOf("]]>")) {
                        return false;
                    }
                    finished = true;
                }
            } else if (s.contains("</body>")) {
                if (this.rawBuffer.lastIndexOf("<![CDATA[") > this.rawBuffer.lastIndexOf("]]>")) {
                    return false;
                }
                finished = true;
            }
        }
        return finished;
    }

    @Override
    public void flush() throws IOException {
        this.analyzeAndOptimizeResponse(System.nanoTime());
    }

    private String logStatistics(long DEBUG_StartTime, long DEBUG_OptimizationTime, String optimizedResponse) {
        int pos;
        DEBUG_OptimizationTime = System.nanoTime() - DEBUG_OptimizationTime;
        long DEBUG_endTime = System.nanoTime();
        this.DEBUG_timer += DEBUG_endTime - DEBUG_StartTime;
        long total = System.nanoTime() - this.DEBUG_totalTimeStart;
        if (total < 500000000L) {
            DEBUG_timerCumulated += this.DEBUG_timer;
            DEBUG_totalTimeCumulated += total;
        }
        if (this.isDeveloperMode && this.sessionMap.containsKey("com.beyondjava.babbageFaces.displayStatistics") && (pos = optimizedResponse.indexOf("<div id=\"babbageFacesStatistics\">")) > 0 && DEBUG_totalTimeCumulated > 0L && total > 0L) {
            optimizedResponse = optimizedResponse.substring(0, pos += "<div id=\"babbageFacesStatistics\">".length()) + "<br />" + "BabbageFaces 1.0 RC2 running on " + (BabbageConfiguration.isMyFaces ? "Apache MyFaces" : "Oracle Mojarra") + "<br />" + "<table><tr>" + "<td>Total rendering time:</td><td>" + (double)(total / 100000L) / 10.0 + " ms</td><td>Cumulated:</td><td> " + (double)(DEBUG_totalTimeCumulated / 10000L) / 10.0 + " ms</td></tr><tr>" + "<td>BabbageFaces overhead:</td><td>" + (double)(this.DEBUG_timer / 100000L) / 10.0 + " ms (" + 100L * this.DEBUG_timer / total + "%)</td><td>Cumulated: </td><td>" + (double)(DEBUG_timerCumulated / 10000L) / 10.0 + " ms (" + 100L * DEBUG_timerCumulated / DEBUG_totalTimeCumulated + "%)</td></tr></table>" + optimizedResponse.substring(pos);
        }
        return optimizedResponse;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        String s;
        boolean endOfPageReached;
        if (this.DEBUG_Finished) {
            if (this.disabledAfterError) {
                this.sunWriter.write(cbuf, off, len);
                return;
            }
            LOGGER.severe("Unexpected use of DifferentialResponseWriter!");
        }
        long DEBUG_StartTime = System.nanoTime();
        this.rawBuffer.append(cbuf, off, len);
        if (cbuf[off] == '\n') {
            ++off;
            --len;
        }
        if (endOfPageReached = this.endOfPage(s = new String(cbuf, off, len))) {
            this.analyzeAndOptimizeResponse(DEBUG_StartTime);
        } else {
            long DEBUG_endTime = System.nanoTime();
            this.DEBUG_timer += DEBUG_endTime - DEBUG_StartTime;
        }
    }
}

