/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.core;

import de.beyondjava.angularFaces.core.ELTools;
import java.lang.annotation.Annotation;
import java.util.Date;
import javax.faces.component.UIComponent;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class NGBeanAttributeInfo {
    private Class<?> clazz;
    private String coreExpression;
    private boolean hasMax = false;
    private boolean hasMaxSize = false;
    private boolean hasMin = false;
    private boolean hasMinSize = false;
    private boolean isDate = false;
    private boolean isBoolean = false;
    private boolean isFloat = false;
    private boolean isInteger = false;
    private boolean isNumeric = false;
    private boolean isRequired = false;
    private long max = 0L;
    private long maxSize = Integer.MIN_VALUE;
    private long min = 0L;
    private long minSize = Integer.MIN_VALUE;

    public NGBeanAttributeInfo(UIComponent component) {
        this.readJSR303Annotations(component);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getCoreExpression() {
        return this.coreExpression;
    }

    public long getMax() {
        return this.max;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public long getMin() {
        return this.min;
    }

    public long getMinSize() {
        return this.minSize;
    }

    public boolean isBoolean() {
        return this.isBoolean;
    }

    public boolean isDate() {
        return this.isDate;
    }

    public boolean isFloat() {
        return this.isFloat;
    }

    public boolean isHasMax() {
        return this.hasMax;
    }

    public boolean isHasMaxSize() {
        return this.hasMaxSize;
    }

    public boolean isHasMin() {
        return this.hasMin;
    }

    public boolean isHasMinSize() {
        return this.hasMinSize;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    private void readJSR303Annotations(UIComponent component) {
        this.coreExpression = ELTools.getCoreValueExpression(component);
        Annotation[] annotations = ELTools.readAnnotations(component);
        if (null != annotations) {
            for (Annotation a : annotations) {
                if (a instanceof Max) {
                    long maximum;
                    this.max = maximum = ((Max)a).value();
                    this.hasMax = true;
                    continue;
                }
                if (a instanceof Min) {
                    long minimum = ((Min)a).value();
                    this.hasMin = true;
                    this.min = minimum;
                    continue;
                }
                if (a instanceof Size) {
                    this.maxSize = ((Size)a).max();
                    this.hasMaxSize = this.maxSize > 0L;
                    this.minSize = ((Size)a).min();
                    this.hasMinSize = this.minSize > 0L;
                    continue;
                }
                if (!(a instanceof NotNull)) continue;
                this.isRequired = true;
            }
        }
        this.clazz = ELTools.getType(component);
        if (this.clazz == Integer.class || this.clazz == Integer.TYPE || this.clazz == Byte.class || this.clazz == Byte.TYPE || this.clazz == Short.class || this.clazz == Short.TYPE || this.clazz == Long.class || this.clazz == Long.TYPE) {
            this.isInteger = true;
            this.isNumeric = true;
        } else if (this.clazz == Double.class || this.clazz == Double.TYPE || this.clazz == Float.class || this.clazz == Float.TYPE) {
            this.isFloat = true;
            this.isNumeric = true;
        } else if (this.clazz == java.sql.Date.class || this.clazz == Date.class) {
            this.isDate = true;
        } else if (this.clazz == Boolean.class || this.clazz == Boolean.TYPE) {
            this.isBoolean = true;
        }
    }
}

