/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.components.puiSync;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class JSONUtilities {
    private static final Logger LOGGER = Logger.getLogger("de.beyondjava.angularFaces.components.puiSync.JSONUtilities");
    private static Object gson;
    private static Object jackson;

    public static Object readObjectFromJSONString(String json, Class<?> beanType) {
        Method method;
        if (null != jackson) {
            try {
                method = jackson.getClass().getMethod("readValue", String.class, Class.class);
                if (null != method) {
                    return method.invoke(jackson, json, beanType);
                }
            }
            catch (InvocationTargetException e) {
                Throwable rootException = e.getTargetException();
                System.out.println("Jackson couldn't read the value: " + rootException);
            }
            catch (ReflectiveOperationException e) {
                System.out.println("Jackson couldn't read the value: " + e);
            }
        }
        if (null != gson) {
            try {
                method = gson.getClass().getMethod("fromJson", String.class, Class.class);
                if (null != method) {
                    return method.invoke(gson, json, beanType);
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String writeObjectToJSONString(Object bean) {
        Method method;
        if (null != jackson) {
            try {
                method = jackson.getClass().getMethod("writeValueAsString", Object.class);
                if (null != method) {
                    return (String)method.invoke(jackson, bean);
                }
            }
            catch (ReflectiveOperationException e) {
                // empty catch block
            }
        }
        if (null != gson) {
            try {
                method = gson.getClass().getMethod("toJson", Object.class);
                if (null != method) {
                    return (String)method.invoke(gson, bean);
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        try {
            Class<?> jacksonClass = Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
            jackson = jacksonClass.newInstance();
        }
        catch (Exception e) {
            try {
                Class<?> jacksonClass = Class.forName("org.codehaus.jackson.map.ObjectMapper");
                jackson = jacksonClass.newInstance();
            }
            catch (Exception e2) {
                jackson = null;
            }
        }
        try {
            Class<?> gsonClass = Class.forName("com.google.gson.Gson");
            gson = gsonClass.newInstance();
        }
        catch (Exception e) {
            gson = null;
        }
        if (jackson == null && gson == null) {
            LOGGER.severe("Please specify a JSON serializer! Current Gson and Jackson 1 and Jackson 2 are supported.");
            LOGGER.severe("To add Jackson, simply add these lines to your pom.xml:");
            LOGGER.severe("<dependency>");
            LOGGER.severe("  <groupId>com.fasterxml.jackson.jaxrs</groupId>");
            LOGGER.severe("  <artifactId>jackson-jaxrs-json-provider</artifactId>");
            LOGGER.severe("  <version>2.4.2</version>");
            LOGGER.severe("</dependency>");
        }
    }
}

