/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.components.puiModelSync;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class PuiScriptRenderer {
    public void encodeScript(FacesContext context, UIComponent component, String name, String library) throws IOException {
        String resourceSrc;
        Map contextMap = context.getAttributes();
        String key = name + library;
        if (null == name) {
            return;
        }
        if (contextMap.containsKey(key)) {
            return;
        }
        contextMap.put(key, Boolean.TRUE);
        int queryPos = name.indexOf("?");
        String query = null;
        if (queryPos > -1 && name.length() > queryPos) {
            query = name.substring(queryPos + 1);
            name = name.substring(0, queryPos);
        }
        Resource resource = context.getApplication().getResourceHandler().createResource(name, library);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", "type");
        if (resource == null) {
            resourceSrc = "RES_NOT_FOUND";
            if (context.isProjectStage(ProjectStage.Development)) {
                String msg = "Unable to find resource " + (library == null ? "" : library + ", ") + name;
                context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
            }
        } else {
            resourceSrc = resource.getRequestPath();
            if (query != null) {
                resourceSrc = resourceSrc + (resourceSrc.indexOf("?") > -1 ? "&amp;" : "?") + query;
            }
            resourceSrc = context.getExternalContext().encodeResourceURL(resourceSrc);
        }
        writer.writeURIAttribute("src", (Object)resourceSrc, "src");
        writer.endElement("script");
    }
}

