/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.core.transformation;

import de.beyondjava.angularFaces.components.puiModelSync.PuiModelSync;
import de.beyondjava.angularFaces.core.tagTransformer.AngularTagDecorator;
import de.beyondjava.angularFaces.core.transformation.AddNGModelAndIDCallback;
import de.beyondjava.angularFaces.core.transformation.AddTypeInformationCallback;
import de.beyondjava.angularFaces.core.transformation.FindNGControllerCallback;
import de.beyondjava.angularFaces.core.transformation.FullVisitContext;
import de.beyondjava.angularFaces.core.transformation.PuiSelectItemTagHandler;
import de.beyondjava.angularFaces.core.transformation.TranslationCallback;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

public class PuiAngularTransformer
implements SystemEventListener {
    private static final Logger LOGGER = Logger.getLogger("de.beyondjava.angularFaces.core.transformation.PuiAngularTransformer");
    private static final String RESOURCE_KEY = "de.beyondjava.angularFaces.core.ResourceFiles";

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        Object source = event.getSource();
        if (source instanceof UIViewRoot) {
            long timer = System.nanoTime();
            final FacesContext context = FacesContext.getCurrentInstance();
            boolean isProduction = context.isProjectStage(ProjectStage.Production);
            if (!isProduction && !AngularTagDecorator.isActive()) {
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_FATAL, "Configuration error: ", "Add javax.faces.FACELETS_DECORATORS=de.beyondjava.angularFaces.core.tagTransformer.AngularTagDecorator to the context init parameters in the web.xml"));
                LOGGER.severe("Add javax.faces.FACELETS_DECORATORS=de.beyondjava.angularFaces.core.tagTransformer.AngularTagDecorator to the context init parameters in the web.xml");
            } else {
                boolean angularFacesRequest;
                final UIViewRoot root = (UIViewRoot)source;
                final boolean ajaxRequest = context.getPartialViewContext().isAjaxRequest();
                boolean bl = angularFacesRequest = ajaxRequest && this.isAngularFacesRequest();
                if (!angularFacesRequest || PuiModelSync.isJSFAttributesTableEmpty()) {
                    PuiModelSync.initJSFAttributesTable();
                    FindNGControllerCallback ngControllerCallback = new FindNGControllerCallback();
                    LOGGER.fine((double)((System.nanoTime() - timer) / 1000L) / 1000.0 + " ms find NGControllerCallback");
                    root.visitTree((VisitContext)new FullVisitContext(context), (VisitCallback)ngControllerCallback);
                    if (!angularFacesRequest) {
                        this.addJavascript(root, context, isProduction);
                    }
                    this.time("add NGModel", new Runnable(){

                        @Override
                        public void run() {
                            root.visitTree((VisitContext)new FullVisitContext(context), (VisitCallback)new AddNGModelAndIDCallback());
                        }
                    });
                    this.time("add type information", new Runnable(){

                        @Override
                        public void run() {
                            root.visitTree((VisitContext)new FullVisitContext(context), (VisitCallback)new AddTypeInformationCallback());
                        }
                    });
                    this.time("convert options to f:selectItem", new Runnable(){

                        @Override
                        public void run() {
                            root.visitTree((VisitContext)new FullVisitContext(context), (VisitCallback)new PuiSelectItemTagHandler());
                        }
                    });
                    this.time("internationalization", new Runnable(){

                        @Override
                        public void run() {
                            root.visitTree((VisitContext)new FullVisitContext(context), (VisitCallback)new TranslationCallback(ajaxRequest));
                        }
                    });
                }
            }
            long time = System.nanoTime() - timer;
            LOGGER.fine((double)(time / 1000L) / 1000.0 + " ms");
        }
    }

    private void addJavascript(UIViewRoot root, FacesContext context, boolean isProduction) {
        UIOutput output;
        boolean loadJQuery = true;
        boolean loadJQueryUI = true;
        boolean loadAngularJS = true;
        boolean loadAngularMessages = true;
        List availableResources = root.getComponentResources(context, "head");
        for (UIComponent ava : availableResources) {
            String name = (String)ava.getAttributes().get("name");
            if (null == name) continue;
            if (name.contains("angular") && name.endsWith(".js")) {
                loadAngularJS = false;
                continue;
            }
            if (name.toLowerCase().contains("angular-messages") && name.toLowerCase().endsWith(".js")) {
                loadAngularMessages = false;
                continue;
            }
            if (name.toLowerCase().contains("jquery-ui") && name.toLowerCase().endsWith(".js")) {
                loadJQueryUI = false;
                continue;
            }
            if (!name.toLowerCase().contains("jquery") || !name.toLowerCase().endsWith(".js")) continue;
            loadJQuery = false;
        }
        if (loadJQuery) {
            output = new UIOutput();
            output.setRendererType("javax.faces.resource.Script");
            if (isProduction) {
                output.getAttributes().put("name", "jquery.min-1.11.1.js");
            } else {
                output.getAttributes().put("name", "jquery-1.11.1.js");
            }
            output.getAttributes().put("library", "jQuery");
            root.addComponentResource(context, (UIComponent)output, "head");
        }
        if (loadJQueryUI) {
            output = new UIOutput();
            output.setRendererType("javax.faces.resource.Script");
            if (isProduction) {
                output.getAttributes().put("name", "jquery-ui.min-1.11.2.js");
            } else {
                output.getAttributes().put("name", "jquery-ui-1.11.2.js");
            }
            output.getAttributes().put("library", "jQuery");
            root.addComponentResource(context, (UIComponent)output, "head");
        }
        if (loadAngularJS) {
            output = new UIOutput();
            output.setRendererType("javax.faces.resource.Script");
            if (isProduction) {
                output.getAttributes().put("name", "angular.min.js");
            } else {
                output.getAttributes().put("name", "angular.js");
            }
            output.getAttributes().put("library", "AngularJS");
            root.addComponentResource(context, (UIComponent)output, "head");
        }
        output = new UIOutput();
        output.setRendererType("javax.faces.resource.Script");
        if (isProduction) {
            output.getAttributes().put("name", "jua-0.1.0.min.js");
        } else {
            output.getAttributes().put("name", "jua-0.1.0.js");
        }
        output.getAttributes().put("library", "AngularFaces");
        root.addComponentResource(context, (UIComponent)output, "head");
        if (loadAngularMessages) {
            output = new UIOutput();
            output.setRendererType("javax.faces.resource.Script");
            if (isProduction) {
                output.getAttributes().put("name", "angular-messages.min.js");
            } else {
                output.getAttributes().put("name", "angular-messages.js");
            }
            output.getAttributes().put("library", "AngularJS");
            root.addComponentResource(context, (UIComponent)output, "head");
        }
        output = new UIOutput();
        output.setRendererType("javax.faces.resource.Script");
        if (isProduction) {
            output.getAttributes().put("name", "angularfaces-core.js");
        } else {
            output.getAttributes().put("name", "angularfaces-core.js");
        }
        output.getAttributes().put("library", "AngularFaces");
        root.addComponentResource(context, (UIComponent)output, "head");
        output = new UIOutput();
        output.setRendererType("javax.faces.resource.Script");
        if (isProduction) {
            output.getAttributes().put("name", "angularfaces-directives.js");
        } else {
            output.getAttributes().put("name", "angularfaces-directives.js");
        }
        output.getAttributes().put("library", "AngularFaces");
        root.addComponentResource(context, (UIComponent)output, "head");
        Locale locale = context.getExternalContext().getRequestLocale();
        String language = locale.getLanguage();
        UIOutput output2 = new UIOutput();
        output2.setRendererType("javax.faces.resource.Script");
        output2.getAttributes().put("name", "messages_" + language + ".js");
        output2.getAttributes().put("library", "AngularFaces");
        root.addComponentResource(context, (UIComponent)output2, "head");
        Map viewMap = root.getViewMap();
        Map resourceMap = (Map)viewMap.get(RESOURCE_KEY);
        if (null != resourceMap) {
            for (Map.Entry entry : resourceMap.entrySet()) {
                String file = (String)entry.getValue();
                String library = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).length() - file.length() - 1);
                UIOutput output3 = new UIOutput();
                output3.setRendererType("javax.faces.resource.Script");
                output3.getAttributes().put("name", file);
                output3.getAttributes().put("library", library);
                root.addComponentResource(context, (UIComponent)output3, "head");
            }
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIComponent;
    }

    private void time(String description, Runnable runnable) {
        long timer = System.nanoTime();
        runnable.run();
        long time = System.nanoTime() - timer;
        LOGGER.fine((double)(time / 1000L) / 1000.0 + " ms " + description);
    }

    private boolean isAngularFacesRequest() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        PartialViewContext pvc = ctx.getPartialViewContext();
        Collection myRenderIds = pvc.getRenderIds();
        boolean isAngularFacesRequest = false;
        if (null != myRenderIds) {
            if (myRenderIds.contains("angular")) {
                isAngularFacesRequest = true;
            } else {
                for (Object id : myRenderIds) {
                    if (!(id instanceof String) || !((String)id).endsWith(":angular")) continue;
                    isAngularFacesRequest = true;
                    break;
                }
            }
        }
        return isAngularFacesRequest;
    }

    public static void addResourceAfterAngularJS(String library, String resource) {
        String key;
        FacesContext ctx = FacesContext.getCurrentInstance();
        UIViewRoot v = ctx.getViewRoot();
        Map viewMap = v.getViewMap();
        HashMap<String, String> resourceMap = (HashMap<String, String>)viewMap.get(RESOURCE_KEY);
        if (null == resourceMap) {
            resourceMap = new HashMap<String, String>();
            viewMap.put(RESOURCE_KEY, resourceMap);
        }
        if (!resourceMap.containsKey(key = library + "#" + resource)) {
            resourceMap.put(key, resource);
        }
    }

    static {
        LOGGER.info("AngularFaces utility class PuiELTransformer ready for use.");
    }
}

