/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.core.transformation;

import de.beyondjava.angularFaces.components.puiModelSync.PuiModelSync;
import de.beyondjava.angularFaces.core.transformation.AttributeUtilities;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;

public class FindNGControllerCallback
implements VisitCallback {
    private PuiModelSync puiModelSync = null;
    private boolean addLabels = true;
    private boolean addMessages = true;

    public boolean isAddLabels() {
        return this.addLabels;
    }

    public boolean isAddMessages() {
        return this.addMessages;
    }

    public VisitResult visit(VisitContext arg0, UIComponent source) {
        String ngController;
        String ngApp;
        String messages;
        if (!(source instanceof UIComponent)) {
            return VisitResult.ACCEPT;
        }
        UIComponent component = source;
        String labels = (String)AttributeUtilities.getAttribute(component, "addLabels");
        if (null != labels) {
            this.addLabels = labels.equalsIgnoreCase("true");
        }
        if (null != (messages = (String)AttributeUtilities.getAttribute(component, "addMessages"))) {
            this.addMessages = messages.equalsIgnoreCase("true");
        }
        if (null != (ngApp = (String)AttributeUtilities.getAttribute(component, "ng-app"))) {
            component.getPassThroughAttributes().put("ng-app", ngApp);
        }
        if (null != (ngController = (String)AttributeUtilities.getAttribute(component, "ng-controller"))) {
            String angularJSFile;
            component.getPassThroughAttributes().put("ng-controller", ngController);
            List children = component.getChildren();
            boolean needsToBeAdded = true;
            for (UIComponent maybe : children) {
                if (!(maybe instanceof PuiModelSync)) continue;
                needsToBeAdded = false;
                this.puiModelSync = (PuiModelSync)maybe;
            }
            if (needsToBeAdded) {
                this.puiModelSync = new PuiModelSync();
                children.add(this.puiModelSync);
            }
            if (null != (angularJSFile = AttributeUtilities.getAttributeAsString(component, "angularJSFile"))) {
                this.puiModelSync.getAttributes().put("angularJSFile", angularJSFile);
            }
            return VisitResult.COMPLETE;
        }
        return VisitResult.ACCEPT;
    }

    public PuiModelSync getPuiModelSync() {
        return this.puiModelSync;
    }
}

