/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.core.tagTransformer;

import de.beyondjava.angularFaces.core.tagTransformer.AFTagAttributes;
import de.beyondjava.angularFaces.core.tagTransformer.TagAttributeUtilities;
import java.util.HashMap;
import java.util.Map;
import javax.faces.view.Location;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagDecorator;

public class RelaxedTagDecorator
implements TagDecorator {
    public Tag decorate(Tag tag) {
        String ns = tag.getNamespace();
        if (!"".equals(ns) && !"http://www.w3.org/1999/xhtml".equals(ns)) {
            throw new FaceletException("Elements with namespace " + ns + " may not have attributes in namespace " + Namespace.jsf.uri + "." + " Namespace " + Namespace.jsf.uri + " is intended for otherwise non-JSF-aware markup, such as <input type=\"text\" jsf:id >" + " It is not valid to have <h:commandButton jsf:id=\"button\" />.");
        }
        for (Mapper mapper : Mapper.values()) {
            if (!tag.getLocalName().equals(mapper.name())) continue;
            return mapper.elementConverter.decorate(tag);
        }
        return null;
    }

    private static class ElementConverter
    implements TagDecorator {
        private String localName;
        private Namespace namespace;
        private String arbiterAttributeName;
        private String arbiterAttributeNamespace = "";
        private Map<String, String> additionalMappings = new HashMap<String, String>();
        private String otherHtmlIdAttribute;

        private ElementConverter() {
        }

        private ElementConverter(String faceletsTag) {
            this(faceletsTag, (String)null);
        }

        private ElementConverter(String faceletsTag, String arbiterAttributeName) {
            String[] strings = faceletsTag.split(":");
            this.namespace = Namespace.valueOf(strings[0]);
            this.localName = strings[1];
            this.arbiterAttributeName = arbiterAttributeName;
            if (arbiterAttributeName != null && arbiterAttributeName.indexOf(58) > 0) {
                strings = arbiterAttributeName.split(":");
                this.arbiterAttributeNamespace = Namespace.valueOf(strings[0]).uri;
                this.arbiterAttributeName = strings[1];
            }
        }

        private ElementConverter map(String arbiterAttributeValue, String faceletsTagLocalName) {
            this.additionalMappings.put(arbiterAttributeValue, faceletsTagLocalName);
            return this;
        }

        private ElementConverter id(String otherHtmlIdAttribute) {
            this.otherHtmlIdAttribute = otherHtmlIdAttribute;
            return this;
        }

        public Tag decorate(Tag tag) {
            if (this.arbiterAttributeName == null) {
                return this.convertTag(tag, this.namespace, this.localName);
            }
            TagAttribute arbiterAttribute = tag.getAttributes().get(this.arbiterAttributeNamespace, this.arbiterAttributeName);
            if (arbiterAttribute == null) {
                return null;
            }
            String myLocalName = this.additionalMappings.get(arbiterAttribute.getValue());
            if (myLocalName == null) {
                myLocalName = this.localName;
            }
            return this.convertTag(tag, this.namespace, myLocalName);
        }

        protected Tag convertTag(Tag tag, Namespace namespace, String localName) {
            Location location = tag.getLocation();
            String ns = namespace.uri;
            String qName = namespace.name() + ":" + localName;
            TagAttributes attributes = this.convertAttributes(tag.getAttributes(), tag);
            Tag converted = new Tag(location, ns, localName, qName, attributes);
            for (TagAttribute tagAttribute : attributes.getAll()) {
                tagAttribute.setTag(converted);
            }
            return converted;
        }

        protected TagAttributes convertAttributes(TagAttributes original, Tag element) {
            HashMap<String, TagAttribute> attributes = new HashMap<String, TagAttribute>();
            TagAttribute elementName = this.createElementName(element);
            attributes.put(elementName.getQName(), elementName);
            for (TagAttribute attribute : original.getAll()) {
                TagAttribute converted = this.convertTagAttribute(attribute);
                attributes.put(converted.getQName(), converted);
            }
            return new AFTagAttributes(attributes.values().toArray(new TagAttribute[attributes.size()]));
        }

        private TagAttribute createElementName(Tag tag) {
            Location location = tag.getLocation();
            String ns = Namespace.p.uri;
            String myLocalName = "elementName";
            String qName = "p:" + myLocalName;
            String value = tag.getLocalName();
            return TagAttributeUtilities.createTagAttribute(location, ns, myLocalName, qName, value);
        }

        protected TagAttribute convertTagAttribute(TagAttribute attribute) {
            String qName;
            Location location = attribute.getLocation();
            String ns = attribute.getNamespace();
            String myLocalName = attribute.getLocalName();
            String value = attribute.getValue();
            if (Namespace.jsf.uri.equals(attribute.getNamespace())) {
                qName = myLocalName;
                ns = "";
            } else {
                if (ns.length() != 0 && !ns.equals(attribute.getTag().getNamespace())) {
                    return attribute;
                }
                if (attribute.getLocalName().equals(this.otherHtmlIdAttribute)) {
                    qName = "id";
                    myLocalName = "id";
                } else {
                    qName = "p:" + myLocalName;
                    ns = Namespace.p.uri;
                }
            }
            return TagAttributeUtilities.createTagAttribute(location, ns, myLocalName, qName, value);
        }
    }

    private static enum Namespace {
        p("http://xmlns.jcp.org/jsf/passthrough"),
        jsf("http://xmlns.jcp.org/jsf"),
        h("http://java.sun.com/jsf/html");

        private String uri;

        private Namespace(String uri) {
            this.uri = uri;
        }
    }

    private static enum Mapper {
        body("h:body"),
        head("h:head"),
        label("h:outputLabel"),
        form("h:form"),
        button(new ElementConverter("h:button", "jsf:outcome"), new ElementConverter("h:commandButton"));

        private ElementConverter elementConverter;

        private Mapper(final ElementConverter ... elementConverters) {
            this.elementConverter = elementConverters.length == 1 ? elementConverters[0] : new ElementConverter(){

                @Override
                public Tag decorate(Tag tag) {
                    for (ElementConverter converter : elementConverters) {
                        Tag decorated = converter.decorate(tag);
                        if (decorated == null) continue;
                        return decorated;
                    }
                    return null;
                }
            };
        }

        private Mapper(String faceletTag) {
            this.elementConverter = new ElementConverter(faceletTag);
        }
    }
}

