/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.core.tagTransformer;

import de.beyondjava.angularFaces.core.Configuration;
import de.beyondjava.angularFaces.core.tagTransformer.AFTagAttributes;
import de.beyondjava.angularFaces.core.tagTransformer.RelaxedTagDecorator;
import de.beyondjava.angularFaces.core.tagTransformer.TagAttributeUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagDecorator;

public class AngularTagDecorator
implements TagDecorator {
    private static boolean active = false;
    private static final Pattern angularExpressionPattern = Pattern.compile("\\{\\{(\\w+\\.)+(\\w+)\\}\\}");
    private static final String HTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    private static final Logger LOGGER = Logger.getLogger("de.beyondjava.angularFaces.core.tagTransformer.AngularTagDecorator");
    private static final String JSF_NAMESPACE = "http://xmlns.jcp.org/jsf/html";
    private static final String JSF_CORE_NAMESPACE = "http://java.sun.com/jsf/core";
    private static final String PASS_THROUGH_NAMESPACE = "http://xmlns.jcp.org/jsf/passthrough";
    private static final String ANGULAR_FACES_CORE_NAMESPACE = "http://beyondjava.net/angularFacesCore";
    private static final String PRIMEFACES_NAMESPACE = "http://primefaces.org/ui";
    private static final String BOOTSFACES_NAMESPACE = "http://bootsfaces.net/ui";
    private static final Map<String, String> bootsfacesTags = new HashMap<String, String>();
    private final RelaxedTagDecorator relaxedDecorator = new RelaxedTagDecorator();

    public static boolean isActive() {
        return active;
    }

    private Tag convertElementToInputText(Tag tag, TagAttributes modifiedAttributes) {
        TagAttribute[] attributes = modifiedAttributes.getAll();
        TagAttribute[] lessAttributes = Arrays.copyOf(attributes, attributes.length - 1);
        AFTagAttributes less = new AFTagAttributes(lessAttributes);
        Tag t = new Tag(tag.getLocation(), JSF_NAMESPACE, "inputText", "h:inputText", (TagAttributes)less);
        return t;
    }

    private Tag convertToInputText(Tag tag, TagAttributes attributeList) {
        TagAttribute[] attributes = attributeList.getAll();
        AFTagAttributes more = new AFTagAttributes(attributes);
        Tag t = new Tag(tag.getLocation(), JSF_NAMESPACE, "inputText", "inputText", (TagAttributes)more);
        return t;
    }

    private Tag convertTofSelectItemText(Tag tag, TagAttributes attributeList) {
        TagAttribute[] attributes = attributeList.getAll();
        AFTagAttributes more = new AFTagAttributes(attributes);
        more.addAttribute(tag.getLocation(), ANGULAR_FACES_CORE_NAMESPACE, "isoption", "ac:isoption", "true");
        Tag t = new Tag(tag.getLocation(), JSF_CORE_NAMESPACE, "selectItem", "selectItem", (TagAttributes)more);
        return t;
    }

    private Tag convertToACBodyTag(Tag tag, TagAttributes attributeList) {
        Tag t = new Tag(tag.getLocation(), ANGULAR_FACES_CORE_NAMESPACE, tag.getLocalName(), tag.getQName(), attributeList);
        return t;
    }

    private Tag convertToNGSyncTag(Tag tag, TagAttributes attributeList) {
        TagAttribute value;
        AFTagAttributes more;
        TagAttribute[] attributes = attributeList.getAll();
        TagAttribute[] newAttributes = new TagAttribute[attributes.length + 1];
        int newLength = 0;
        String direction = "serverToClient";
        String angularExpression = null;
        int indexOfValueAttribute = -1;
        for (int i = 0; i < attributes.length; ++i) {
            if ("value".equals(attributes[i].getLocalName())) {
                indexOfValueAttribute = i;
                angularExpression = attributes[i].getValue();
                if (angularExpression.startsWith("#{")) {
                    angularExpression = "{{" + angularExpression.substring(2, angularExpression.length() - 1) + "}}";
                }
                TagAttribute af = TagAttributeUtilities.createTagAttribute(tag.getLocation(), "", "angularfacesattributes", "angularfacesattributes", angularExpression);
                newAttributes[newLength++] = af;
                continue;
            }
            if ("direction".equals(attributes[i].getLocalName())) {
                direction = attributes[i].getValue();
                newAttributes[newLength++] = attributes[i];
                continue;
            }
            if ("id".equals(attributes[i].getLocalName())) {
                newAttributes[newLength++] = attributes[i];
                continue;
            }
            if ("styleClass".equals(attributes[i].getLocalName())) {
                newAttributes[newLength++] = attributes[i];
                continue;
            }
            if ("once".equals(attributes[i].getLocalName())) {
                newAttributes[newLength++] = attributes[i];
                continue;
            }
            if (!"cacheable".equals(attributes[i].getLocalName())) continue;
            newAttributes[newLength++] = attributes[i];
        }
        if (null == angularExpression) {
            LOGGER.severe("ngsync: Please provide the value attribute containing the bean that is to be synchronized.");
            TagAttribute value2 = TagAttributeUtilities.createTagAttribute(tag.getLocation(), "", "value", "value", "ngsync: Please provide the value attribute containing the bean that is to be synchronized.");
            newAttributes[newLength++] = value2;
            newAttributes = Arrays.copyOf(newAttributes, newLength);
            more = new AFTagAttributes(newAttributes);
            Tag t = new Tag(tag.getLocation(), JSF_NAMESPACE, "outputText", "outputText", (TagAttributes)more);
            return t;
        }
        if ("serverToClient".equalsIgnoreCase(direction)) {
            TagAttribute hide = TagAttributeUtilities.createTagAttribute(tag.getLocation(), "", "rendered", "rendered", "true");
            newAttributes[newLength++] = hide;
            newAttributes = Arrays.copyOf(newAttributes, newLength);
            more = new AFTagAttributes(newAttributes);
            Tag t = new Tag(tag.getLocation(), ANGULAR_FACES_CORE_NAMESPACE, "sync", "sync", (TagAttributes)more);
            return t;
        }
        String coreExpression = angularExpression.substring(2, angularExpression.length() - 2);
        newAttributes[indexOfValueAttribute] = value = TagAttributeUtilities.createTagAttribute(tag.getLocation(), "", "value", "value", coreExpression);
        newAttributes = Arrays.copyOf(newAttributes, newLength);
        AFTagAttributes more2 = new AFTagAttributes(newAttributes);
        Tag t = new Tag(tag.getLocation(), ANGULAR_FACES_CORE_NAMESPACE, "sync", "sync", (TagAttributes)more2);
        return t;
    }

    private Tag convertToTranslateTag(Tag tag, TagAttributes modifiedAttributes) {
        TagAttribute[] attributes = modifiedAttributes.getAll();
        AFTagAttributes more = new AFTagAttributes(attributes);
        if (null == more.get(JSF_NAMESPACE, "value")) {
            more.addAttribute(tag.getLocation(), ANGULAR_FACES_CORE_NAMESPACE, "puitranslate", "ac:puitranslate", "true");
        }
        Tag t = new Tag(tag.getLocation(), JSF_NAMESPACE, "outputText", "h:outputText", (TagAttributes)more);
        return t;
    }

    public Tag decorate(Tag tag) {
        Tag newTag = this.createTags(tag);
        return newTag;
    }

    private Tag createTags(Tag tag) {
        TagAttribute tagAttribute;
        active = true;
        TagAttributes modifiedAttributes = this.extractAngularAttributes(tag);
        if ("element".equals(tag.getLocalName()) && "input".equals((tagAttribute = modifiedAttributes.get(PASS_THROUGH_NAMESPACE, "elementName")).getValue())) {
            return this.convertElementToInputText(tag, modifiedAttributes);
        }
        if ("body".equals(tag.getLocalName())) {
            return this.convertToACBodyTag(tag, modifiedAttributes);
        }
        if ("messages".equals(tag.getLocalName())) {
            return this.convertToPuiMessagesTag(tag, modifiedAttributes);
        }
        if (!this.isHTMLNamespace(tag.getNamespace())) {
            return this.generateTagIfNecessary(tag, modifiedAttributes);
        }
        Tag newTag = this.relaxedDecorator.decorate(tag);
        if (newTag != null && newTag != tag) {
            return newTag;
        }
        if ("translate".equals(tag.getLocalName()) || "i18n".equals(tag.getLocalName())) {
            return this.convertToTranslateTag(tag, modifiedAttributes);
        }
        if ("ngsync".equals(tag.getLocalName())) {
            return this.convertToNGSyncTag(tag, modifiedAttributes);
        }
        if ("input".equals(tag.getLocalName())) {
            return this.convertToInputText(tag, modifiedAttributes);
        }
        if ("option".equals(tag.getLocalName())) {
            return this.convertTofSelectItemText(tag, modifiedAttributes);
        }
        tag = this.convertBootsFacesTag(tag);
        return this.generateTagIfNecessary(tag, modifiedAttributes);
    }

    private Tag convertBootsFacesTag(Tag tag) {
        String tagname;
        if (HTML_NAMESPACE.equals(tag.getNamespace()) && bootsfacesTags.containsKey(tagname = tag.getLocalName())) {
            AFTagAttributes modifiedAttributes = new AFTagAttributes(tag.getAttributes().getAll());
            Tag t = new Tag(tag.getLocation(), BOOTSFACES_NAMESPACE, tag.getLocalName(), tag.getQName(), (TagAttributes)modifiedAttributes);
            return t;
        }
        return tag;
    }

    private Tag convertToPuiMessagesTag(Tag tag, TagAttributes attributeList) {
        if (tag.getNamespace().equals(PRIMEFACES_NAMESPACE)) {
            AFTagAttributes modifiedAttributes = new AFTagAttributes(attributeList.getAll());
            modifiedAttributes.addAttribute(tag.getLocation(), PASS_THROUGH_NAMESPACE, "primefaces", "primefaces", "true");
            Tag t = new Tag(tag.getLocation(), HTML_NAMESPACE, "puimessages", "puimessages", (TagAttributes)modifiedAttributes);
            return t;
        }
        Tag t = new Tag(tag.getLocation(), HTML_NAMESPACE, "puimessages", "puimessages", attributeList);
        return t;
    }

    private TagAttributes extractAngularAttributes(Tag tag) {
        TagAttribute[] attrs = tag.getAttributes().getAll();
        ArrayList<TagAttribute> modified = new ArrayList<TagAttribute>();
        boolean hasChanges = false;
        String angularExpressions = "";
        for (TagAttribute a : attrs) {
            TagAttribute modifiedAttribute;
            String modifiedValue = a.getValue();
            boolean firstMatch = true;
            Matcher matcher = angularExpressionPattern.matcher(a.getValue());
            while (matcher.find()) {
                String exp = matcher.group();
                angularExpressions = angularExpressions + "," + exp;
                modifiedValue = modifiedValue.replace(exp, "#" + exp.substring(1, exp.length() - 1));
                if ("value".equals(a.getLocalName())) {
                    TagAttribute modifiedAttribute2 = TagAttributeUtilities.createTagAttribute(a.getLocation(), PASS_THROUGH_NAMESPACE, "ng-model", "ng-model", exp.substring(2, exp.length() - 2));
                    modified.add(modifiedAttribute2);
                    if (!firstMatch) {
                        LOGGER.severe("Tag " + tag.getQName() + " can't have multiple ng-models." + tag.getLocation().toString());
                    }
                    firstMatch = false;
                }
                hasChanges = true;
            }
            if (a.getLocalName().startsWith("ng-")) {
                modifiedAttribute = TagAttributeUtilities.createTagAttribute(a.getLocation(), PASS_THROUGH_NAMESPACE, a.getLocalName(), a.getLocalName(), modifiedValue);
                hasChanges = true;
            } else {
                modifiedAttribute = TagAttributeUtilities.createTagAttribute(a.getLocation(), a.getNamespace(), a.getLocalName(), a.getQName(), modifiedValue);
            }
            modified.add(modifiedAttribute);
        }
        if (hasChanges) {
            if (angularExpressions.length() > 0) {
                TagAttribute af = TagAttributeUtilities.createTagAttribute(tag.getLocation(), "", "angularfacesattributes", "angularfacesattributes", angularExpressions.substring(1));
                modified.add(0, af);
            }
            TagAttribute[] modifiedAttributeList = new TagAttribute[modified.size()];
            for (int i = 0; i < modified.size(); ++i) {
                modifiedAttributeList[i] = (TagAttribute)modified.get(i);
            }
            return new AFTagAttributes(modifiedAttributeList);
        }
        return tag.getAttributes();
    }

    private Tag generateTagIfNecessary(Tag tag, TagAttributes modifiedAttributes) {
        if (modifiedAttributes != tag.getAttributes()) {
            if (tag.getLocalName().equals("div") && modifiedAttributes instanceof AFTagAttributes) {
                return this.generatePuiHtmlTag(tag, modifiedAttributes, "puiDiv");
            }
            if (tag.getLocalName().equals("span") && modifiedAttributes instanceof AFTagAttributes) {
                return this.generatePuiHtmlTag(tag, modifiedAttributes, "puiSpan");
            }
            return new Tag(tag.getLocation(), tag.getNamespace(), tag.getLocalName(), tag.getQName(), modifiedAttributes);
        }
        return null;
    }

    private Tag generatePuiHtmlTag(Tag tag, TagAttributes modifiedAttributes, String htmlTag) {
        String keys = "";
        TagAttribute[] all = modifiedAttributes.getAll();
        for (int i = 0; i < all.length; ++i) {
            TagAttribute attr = all[i];
            keys = keys + attr.getLocalName() + ",";
            all[i] = TagAttributeUtilities.createTagAttribute(attr.getLocation(), PASS_THROUGH_NAMESPACE, attr.getLocalName(), attr.getQName(), attr.getValue());
        }
        if (keys.endsWith(",")) {
            keys = keys.substring(0, keys.length() - 1);
        }
        ((AFTagAttributes)modifiedAttributes).addAttribute(tag.getLocation(), ANGULAR_FACES_CORE_NAMESPACE, "attributeNames", "attributeNames", keys);
        return new Tag(tag.getLocation(), ANGULAR_FACES_CORE_NAMESPACE, htmlTag, htmlTag, modifiedAttributes);
    }

    private boolean isHTMLNamespace(String ns) {
        return "".equals(ns) || HTML_NAMESPACE.equals(ns);
    }

    static {
        if (Configuration.bootsFacesActive) {
            bootsfacesTags.put("alert", "alert");
            bootsfacesTags.put("badge", "badge");
            bootsfacesTags.put("modal", "modal");
            bootsfacesTags.put("commandButton", "commandButton");
            bootsfacesTags.put("buttonGroup", "buttonGroup");
            bootsfacesTags.put("buttonToolbar", "buttonToolbar");
            bootsfacesTags.put("navBar", "navBar");
            bootsfacesTags.put("navbarLinks", "navbarLinks");
            bootsfacesTags.put("listLinks", "listLinks");
            bootsfacesTags.put("navLink", "navLink");
            bootsfacesTags.put("dropButton", "dropButton");
            bootsfacesTags.put("dropMenu", "dropMenu");
            bootsfacesTags.put("thumbnail", "thumbnail");
            bootsfacesTags.put("container", "container");
            bootsfacesTags.put("row", "row");
            bootsfacesTags.put("column", "column");
            bootsfacesTags.put("panel", "panel");
            bootsfacesTags.put("panelGrid", "panelGrid");
            bootsfacesTags.put("jumbotron", "jumbotron");
            bootsfacesTags.put("well", "well");
            bootsfacesTags.put("datepicker", "datepicker");
            bootsfacesTags.put("slider", "slider");
            bootsfacesTags.put("inputSecret", "inputSecret");
            bootsfacesTags.put("inputText", "inputText");
            bootsfacesTags.put("selectBooleanCheckbox", "selectBooleanCheckbox");
            bootsfacesTags.put("selectOneMenu", "selectOneMenu");
            bootsfacesTags.put("tabView", "tabView");
            bootsfacesTags.put("tab", "tab");
        }
    }
}

