/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.core;

import de.beyondjava.angularFaces.core.NGBeanAttributeInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.beanutils.BeanUtilsBean2;

public class ELTools {
    private static final Pattern EL_EXPRESSION = Pattern.compile("#\\{\\{([A-Z_$\u20ac]|[a-z_0-9$\u20ac]|\\.)+\\}");
    private static Map<String, NGBeanAttributeInfo> beanAttributeInfos = new HashMap<String, NGBeanAttributeInfo>();
    private static final Logger LOGGER = Logger.getLogger("de.beyondjava.angularFaces.common.ELTools");

    public static ValueExpression createValueExpression(String p_expression) {
        FacesContext context = FacesContext.getCurrentInstance();
        ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
        ELContext elContext = context.getELContext();
        ValueExpression vex = expressionFactory.createValueExpression(elContext, p_expression, Object.class);
        return vex;
    }

    public static ValueExpression createValueExpression(String p_expression, Class expectedType) {
        FacesContext context = FacesContext.getCurrentInstance();
        ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
        ELContext elContext = context.getELContext();
        if (null == expectedType) {
            LOGGER.severe("The expected type of " + p_expression + " is null. Defaulting to String.");
            expectedType = String.class;
        }
        ValueExpression vex = expressionFactory.createValueExpression(elContext, p_expression, (Class)expectedType);
        return vex;
    }

    public static Object evalAsObject(String p_expression) throws PropertyNotFoundException {
        ELContext elContext;
        FacesContext context = FacesContext.getCurrentInstance();
        ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
        ValueExpression vex = expressionFactory.createValueExpression(elContext = context.getELContext(), p_expression, Object.class);
        Object result = vex.getValue(elContext);
        if (null == result) {
            vex.getValueReference(elContext);
        }
        return result;
    }

    public static String evalAsString(String p_expression) {
        FacesContext context = FacesContext.getCurrentInstance();
        ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
        ELContext elContext = context.getELContext();
        ValueExpression vex = expressionFactory.createValueExpression(elContext, p_expression, String.class);
        String result = (String)vex.getValue(elContext);
        return result;
    }

    public static List<String> getArrayProperties(String p_expression, boolean p_recursive) {
        Object container = ELTools.evalAsObject("#{" + p_expression + "}");
        Class<?> c = container == null ? null : container.getClass();
        ArrayList<String> propertyNames = new ArrayList<String>();
        if (ELTools.isPrimitive(c)) {
            propertyNames.add(p_expression);
        } else {
            try {
                Map description = BeanUtilsBean2.getInstance().describe(container);
                for (String o : description.keySet()) {
                    Object property;
                    Object object = description.get(o);
                    if (object != null) continue;
                    String getter = "get" + o.substring(0, 1).toUpperCase() + o.substring(1);
                    Method method = container.getClass().getMethod(getter, new Class[0]);
                    if (null == method || null == (property = method.invoke(container, new Object[0])) || !(property instanceof List)) continue;
                    LOGGER.info("List");
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.SEVERE, "Couldn\"t read property list of " + p_expression, e);
            }
            catch (InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, "Couldn\"t read property list of " + p_expression, e);
            }
            catch (NoSuchMethodException e) {
                LOGGER.log(Level.SEVERE, "Couldn\"t read property list of " + p_expression, e);
            }
        }
        return propertyNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NGBeanAttributeInfo getBeanAttributeInfos(UIComponent c) {
        String core = ELTools.getCoreValueExpression(c);
        Map<String, NGBeanAttributeInfo> map = beanAttributeInfos;
        synchronized (map) {
            if (beanAttributeInfos.containsKey(c)) {
                return beanAttributeInfos.get(c);
            }
        }
        NGBeanAttributeInfo info = new NGBeanAttributeInfo(c);
        Map<String, NGBeanAttributeInfo> map2 = beanAttributeInfos;
        synchronized (map2) {
            beanAttributeInfos.put(core, info);
        }
        return info;
    }

    public static String getCoreValueExpression(UIComponent component) {
        String v;
        ValueExpression valueExpression = component.getValueExpression("value");
        if (null != valueExpression && null != (v = valueExpression.getExpressionString())) {
            Matcher matcher = EL_EXPRESSION.matcher(v);
            if (matcher.find()) {
                String exp = matcher.group();
                return exp.substring(2, exp.length() - 1);
            }
            return v;
        }
        return null;
    }

    public static List<String> getEveryProperty(String p_expression, boolean p_recursive) {
        Object container = ELTools.evalAsObject("#{" + p_expression + "}");
        Class<?> c = container == null ? null : container.getClass();
        ArrayList<String> propertyNames = new ArrayList<String>();
        if (ELTools.isPrimitive(c)) {
            propertyNames.add(p_expression);
        } else {
            try {
                Map description = BeanUtilsBean2.getInstance().describe(container);
                for (String o : description.keySet()) {
                    Object object = description.get(o);
                    if (object == null || o.equals("class")) continue;
                    if (ELTools.isPrimitive(object.getClass())) {
                        propertyNames.add(o);
                        continue;
                    }
                    if (!p_recursive) continue;
                    List<String> nested = ELTools.getEveryProperty(p_expression + "." + o, p_recursive);
                    for (String n : nested) {
                        propertyNames.add(o + "." + n);
                    }
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.SEVERE, "Couldn\"t read property list of " + p_expression, e);
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, "Couldn\"t read property list of " + p_expression, e);
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                LOGGER.log(Level.SEVERE, "Couldn\"t read property list of " + p_expression, e);
            }
        }
        return propertyNames;
    }

    private static Field getField(String p_expression) {
        if (p_expression.startsWith("#{") && p_expression.endsWith("}")) {
            int delimiterPos = p_expression.lastIndexOf(46);
            if (delimiterPos < 0) {
                LOGGER.log(Level.WARNING, "There's no field to access: #{" + p_expression + "}");
                return null;
            }
            String beanExp = p_expression.substring(0, delimiterPos) + "}";
            String fieldName = p_expression.substring(delimiterPos + 1, p_expression.length() - 1);
            Object container = ELTools.evalAsObject(beanExp);
            if (null == container) {
                LOGGER.severe("Can't read the bean '" + beanExp + "'. Thus JSR 303 annotations can't be read, let alone used by the AngularJS / AngularDart client.");
                return null;
            }
            for (Class<?> c = container.getClass(); c != null; c = c.getSuperclass()) {
                try {
                    Field declaredField = c.getDeclaredField(fieldName);
                    return declaredField;
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
                catch (SecurityException e) {
                    LOGGER.log(Level.SEVERE, "Unable to access a field", e);
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return null;
    }

    private static Method getGetter(String p_expression) {
        if (p_expression.startsWith("#{") && p_expression.endsWith("}")) {
            int delimiterPos = p_expression.lastIndexOf(46);
            if (delimiterPos < 0) {
                LOGGER.log(Level.WARNING, "There's no getter to access: #{" + p_expression + "}");
                return null;
            }
            String beanExp = p_expression.substring(0, delimiterPos) + "}";
            String fieldName = p_expression.substring(delimiterPos + 1, p_expression.length() - 1);
            String getterName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            String booleanGetterName = "is" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Object container = ELTools.evalAsObject(beanExp);
            if (null == container) {
                LOGGER.severe("Can't read the bean '" + beanExp + "'. Thus JSR 303 annotations can't be read, let alone used by the AngularJS / AngularDart client.");
                return null;
            }
            Method declaredMethod = ELTools.findMethod(container, getterName);
            if (null == declaredMethod) {
                declaredMethod = ELTools.findMethod(container, booleanGetterName);
            }
            return declaredMethod;
        }
        return null;
    }

    private static Method findMethod(Object container, String getterName) {
        Class<?> c = container.getClass();
        try {
            Method declaredField = c.getMethod(getterName, new Class[0]);
            return declaredField;
        }
        catch (NoSuchMethodException e) {
            c = c.getSuperclass();
        }
        catch (SecurityException e) {
            LOGGER.log(Level.SEVERE, "Unable to access a getter for security reasons", e);
            e.printStackTrace();
        }
        return null;
    }

    public static String getNGModel(UIComponent p_component) {
        String id = ELTools.getCoreValueExpression(p_component);
        if (id.contains(".")) {
            int index = id.lastIndexOf(".");
            id = id.substring(index + 1);
        }
        return id;
    }

    public static Class<?> getType(String p_expression) {
        Method declaredField = ELTools.getGetter(p_expression);
        if (null != declaredField) {
            return declaredField.getReturnType();
        }
        return null;
    }

    public static Class<?> getType(UIComponent p_component) {
        ValueExpression valueExpression = p_component.getValueExpression("value");
        if (valueExpression != null) {
            return ELTools.getType(valueExpression.getExpressionString());
        }
        return null;
    }

    public static boolean hasValueExpression(UIComponent component) {
        ValueExpression valueExpression = component.getValueExpression("value");
        return null != valueExpression;
    }

    private static boolean isPrimitive(Class<? extends Object> c) {
        return null == c || Class.class == c || String.class == c || c.isPrimitive() || Integer.class == c || Long.class == c || Short.class == c || Byte.class == c || Character.class == c || Float.class == c || Double.class == c || Void.class == c || Boolean.class == c;
    }

    public static Annotation[] readAnnotations(String p_expression) {
        Field declaredField = ELTools.getField(p_expression);
        if (null != declaredField && declaredField.getAnnotations() != null) {
            return declaredField.getAnnotations();
        }
        Method getter = ELTools.getGetter(p_expression);
        if (null != getter) {
            return getter.getAnnotations();
        }
        return null;
    }

    public static Annotation[] readAnnotations(UIComponent p_component) {
        ValueExpression valueExpression = p_component.getValueExpression("value");
        if (valueExpression != null) {
            return ELTools.readAnnotations(valueExpression.getExpressionString());
        }
        return null;
    }
}

