/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.components.puiModelSync;

import de.beyondjava.angularFaces.components.puiSync.JSONUtilities;
import de.beyondjava.angularFaces.core.ELTools;
import de.beyondjava.angularFaces.core.transformation.AttributeUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.PropertyNotFoundException;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.FacesComponent;
import javax.faces.component.StateHelper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlBody;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

@FacesComponent(value="de.beyondjava.kendoFaces.puiBody.PuiBody")
public class PuiModelSync
extends HtmlBody {
    private static final String JSF_ATTRIBUTES_SESSION_PARAMETER = "de.beyondjava.angularFaces.jsfAttributes";
    private static final String JSF_ATTRIBUTES_SESSION_CACHE = "de.beyondjava.angularFaces.cache";
    private static final Logger LOGGER = Logger.getLogger("de.beyondjava.kendoFaces.puiBody.PuiBody");

    public StateHelper getStateHelper() {
        return super.getStateHelper();
    }

    public static boolean isJSFAttributesTableEmpty() {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        Map jsfAttributes = (Map)sessionMap.get(JSF_ATTRIBUTES_SESSION_PARAMETER);
        return null == jsfAttributes || jsfAttributes.isEmpty();
    }

    public static void initJSFAttributesTable() {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        if (!sessionMap.containsKey(JSF_ATTRIBUTES_SESSION_PARAMETER)) {
            sessionMap.put(JSF_ATTRIBUTES_SESSION_PARAMETER, new HashMap());
            sessionMap.put(JSF_ATTRIBUTES_SESSION_CACHE, new HashMap());
        } else {
            Map jsfAttributes = (Map)sessionMap.get(JSF_ATTRIBUTES_SESSION_PARAMETER);
            jsfAttributes.clear();
        }
    }

    public static void addJSFAttrbitute(String key, UIComponent component, boolean cacheable, boolean onlyOnce) {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        Map jsfAttributes = (Map)sessionMap.get(JSF_ATTRIBUTES_SESSION_PARAMETER);
        String suffix = cacheable ? "1" : "0";
        suffix = suffix + (onlyOnce ? "1" : "0");
        jsfAttributes.put(key, component.getClientId() + suffix);
    }

    public static void addJSFAttrbituteToAngularModel(Map<String, Object> model, String key, Object value, boolean cacheable) {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        Map cache = (Map)sessionMap.get(JSF_ATTRIBUTES_SESSION_CACHE);
        if (cache.containsKey(key)) {
            if (cacheable && FacesContext.getCurrentInstance().isPostback()) {
                Object previousValue = cache.get(key);
                if (null == value && previousValue == null) {
                    return;
                }
                if (null != value && value.equals(previousValue)) {
                    return;
                }
            }
            cache.remove(key);
        }
        cache.put(key, value);
        String[] keys = key.split("\\.");
        Map currentMap = model;
        for (int i = 0; i < keys.length - 1; ++i) {
            Object object;
            if (!currentMap.containsKey(keys[i])) {
                currentMap.put((String)keys[i], new HashMap());
            }
            if (!((object = currentMap.get(keys[i])) instanceof Map)) {
                return;
            }
            currentMap = (Map)object;
        }
        currentMap.put((String)keys[keys.length - 1], (Object)value);
    }

    public static List<String> getFacesModel() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        Map jsfAttributes = (Map)sessionMap.get(JSF_ATTRIBUTES_SESSION_PARAMETER);
        UIViewRoot root = FacesContext.getCurrentInstance().getViewRoot();
        for (Map.Entry entry : jsfAttributes.entrySet()) {
            try {
                Object value;
                boolean onlyOnce;
                String attribute = (String)entry.getKey();
                int length = ((String)entry.getValue()).length();
                String id = ((String)entry.getValue()).substring(0, length - 2);
                boolean cacheable = ((String)entry.getValue()).charAt(length - 2) == '1';
                boolean bl = onlyOnce = ((String)entry.getValue()).charAt(length - 1) == '1';
                if (onlyOnce && FacesContext.getCurrentInstance().isPostback()) continue;
                UIComponent comp = root.findComponent(id);
                if (null != comp && comp instanceof EditableValueHolder) {
                    value = ELTools.evalAsObject("#{" + attribute + "}");
                    Object valueToRender = PuiModelSync.getValueToRender(FacesContext.getCurrentInstance(), comp);
                    if (value != null && valueToRender != null && valueToRender instanceof String) {
                        try {
                            valueToRender = PuiModelSync.convertToDatatype((String)valueToRender, value.getClass());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (null != valueToRender) {
                        PuiModelSync.addJSFAttrbituteToAngularModel(model, attribute, valueToRender, cacheable);
                        continue;
                    }
                    PuiModelSync.addJSFAttrbituteToAngularModel(model, attribute, value, cacheable);
                    continue;
                }
                value = ELTools.evalAsObject("#{" + attribute + "}");
                PuiModelSync.addJSFAttrbituteToAngularModel(model, attribute, value, cacheable);
            }
            catch (PropertyNotFoundException pureAngularAttribute) {}
        }
        ArrayList<String> beans = new ArrayList<String>();
        String messages = "";
        List messageList = FacesContext.getCurrentInstance().getMessageList();
        for (FacesMessage message : messageList) {
            if (message.isRendered()) continue;
            String severity = message.getSeverity().toString();
            String summary = message.getSummary().replace("'", "\\'");
            String detail = message.getDetail().replace("'", "\\'");
            messages = messages + ",{\"severity\":\"" + severity + "\", \"summary\":\"" + summary + "\", \"detail\":\"" + detail + "\"}";
            message.rendered();
        }
        if (messages.length() > 0) {
            String assignment = "\"facesmessages\", '[" + messages.substring(1) + "]'";
            beans.add(assignment);
        }
        for (Map.Entry bean : model.entrySet()) {
            String assignment = "\"" + (String)bean.getKey() + "\",'" + JSONUtilities.writeObjectToJSONString(bean.getValue()) + "'";
            beans.add(assignment);
        }
        return beans;
    }

    private static Object convertToDatatype(String valueToRender, Class targetClass) {
        if ("".equals(valueToRender)) {
            return null;
        }
        if (null == valueToRender) {
            return null;
        }
        if (valueToRender.getClass() == targetClass) {
            return valueToRender;
        }
        if (targetClass == Integer.TYPE) {
            return (int)new Integer(valueToRender);
        }
        if (targetClass == Long.TYPE) {
            return (long)new Long(valueToRender);
        }
        if (targetClass == Short.TYPE) {
            return (short)new Short(valueToRender);
        }
        if (targetClass == Float.TYPE) {
            return Float.valueOf(new Float(valueToRender).floatValue());
        }
        if (targetClass == Double.TYPE) {
            return (double)new Double(valueToRender);
        }
        if (targetClass == Byte.TYPE) {
            return (byte)new Byte(valueToRender);
        }
        if (targetClass == Integer.class) {
            return new Integer(valueToRender);
        }
        if (targetClass == Long.class) {
            return new Long(valueToRender);
        }
        if (targetClass == Short.class) {
            return new Short(valueToRender);
        }
        if (targetClass == Float.class) {
            return new Float(valueToRender);
        }
        if (targetClass == Double.class) {
            return new Double(valueToRender);
        }
        if (targetClass == Byte.class) {
            return new Byte(valueToRender);
        }
        return null;
    }

    public static Object getValueToRender(FacesContext context, UIComponent component) {
        if (component instanceof ValueHolder) {
            if (component instanceof EditableValueHolder) {
                EditableValueHolder input = (EditableValueHolder)component;
                Object submittedValue = input.getSubmittedValue();
                if (submittedValue == null && context.isValidationFailed() && !input.isValid()) {
                    return null;
                }
                if (submittedValue != null) {
                    return submittedValue;
                }
            }
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            return value;
        }
        return null;
    }

    public void encodeAll(FacesContext arg0) throws IOException {
        this.encodeBegin(arg0);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        String main;
        ResponseWriter writer = context.getResponseWriter();
        boolean debugMode = context.isProjectStage(ProjectStage.Development);
        if (debugMode) {
            writer.append((CharSequence)"\r\n");
        }
        writer.startElement("script", (UIComponent)this);
        if (debugMode) {
            writer.append((CharSequence)"\r\n");
        }
        writer.writeText((Object)"window.jsfScope=null;", null);
        if (debugMode) {
            writer.append((CharSequence)"\r\n");
        }
        writer.writeText((Object)"function initJSFScope($scope){", null);
        if (debugMode) {
            writer.append((CharSequence)"\r\n  ");
        }
        writer.write("if (window.jsfScope==null) {");
        writer.writeText((Object)"window.jsfScope=$scope;", null);
        if (debugMode) {
            writer.append((CharSequence)"\r\n  ");
        }
        if (debugMode) {
            writer.append((CharSequence)"\r\n  ");
        }
        List<String> beansAsJSon = PuiModelSync.getFacesModel();
        for (String bean : beansAsJSon) {
            writer.writeText((Object)("puiUpdateModel(" + bean + ");"), null);
        }
        if (debugMode) {
            writer.append((CharSequence)"\r\n");
        }
        writer.writeText((Object)"}", null);
        if (debugMode) {
            writer.append((CharSequence)"\r\n");
        }
        writer.writeText((Object)"}", null);
        if (debugMode) {
            writer.append((CharSequence)"\r\n");
        }
        writer.endElement("script");
        if (debugMode) {
            writer.append((CharSequence)"\r\n");
        }
        if ((main = AttributeUtilities.getAttributeAsString((UIComponent)this, "angularJSFile")) == null) {
            main = "main.js";
        }
        if (!main.endsWith(".js")) {
            main = main + ".js";
        }
        writer.append((CharSequence)("<script src='" + main + "'></script>"));
    }

    public void encodeChildren(FacesContext arg0) throws IOException {
    }

    public void encodeEnd(FacesContext arg0) throws IOException {
    }
}

