/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.core.transformation;

import de.beyondjava.angularFaces.core.ELTools;
import de.beyondjava.angularFaces.core.i18n.I18n;
import de.beyondjava.angularFaces.core.transformation.AttributeUtilities;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;

public class TranslationCallback
implements VisitCallback {
    I18n i18n = null;
    int duplicateLabels = 0;
    String[] attributesToBeTranslated = new String[]{"header", "headerText", "addLabel", "addAllLabel", "cancelLabel", "closeTitle", "collapseTitle", "converterMessage", "emptyLabel", "expandTitle", "fileLimitMessage", "goodLabel", "iframeTitle", "invalidFileMessage", "invalidSizeMessage", "itemLabel", "label", "menuTitle", "message", "moveButtomLabel", "moveDownLabel", "moveUpLabel", "moveTopLabel", "removeAllLabel", "removeLabel", "removeFrom", "removeLabel", "requiredMessage", "resizeTitle", "saveLabel", "summary", "titletip", "toggleTitle", "tooltip", "uploadLabel", "validatorMessage", "welcomeMessage"};

    public VisitResult visit(VisitContext arg0, UIComponent component) {
        for (String attributeName : this.attributesToBeTranslated) {
            this.translateAttribute(component, attributeName);
        }
        if (component instanceof UICommand || component instanceof UIOutput) {
            this.translateAttribute(component, "value");
        }
        return VisitResult.ACCEPT;
    }

    private void translateAttribute(UIComponent component, String attributeName) {
        String translation;
        String caption;
        Object value = AttributeUtilities.getAttribute(component, attributeName);
        if (null != value && value instanceof String && null != (caption = (String)value) && !caption.equals(translation = this.translate(caption))) {
            component.getAttributes().put(attributeName, translation);
        }
    }

    private String translate(String caption) {
        if (null == this.i18n) {
            this.i18n = (I18n)ELTools.evalAsObject("#{i18n}");
        }
        if (null == this.i18n) {
            return caption;
        }
        return this.i18n.translate(caption);
    }
}

