/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.components.puiLabel;

import de.beyondjava.angularFaces.components.puiLabel.PuiLabel;
import de.beyondjava.angularFaces.components.puiMessage.PuiMessage;
import de.beyondjava.angularFaces.components.puiSync.PuiSync;
import de.beyondjava.angularFaces.core.ELTools;
import de.beyondjava.angularFaces.core.NGWordUtiltites;
import de.beyondjava.angularFaces.core.i18n.I18n;
import de.beyondjava.angularFaces.core.transformation.AttributeUtilities;
import java.io.IOException;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIMessage;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;

public class AddLabelsAndMessagesHandler
extends TagHandler {
    private I18n i18n = null;
    boolean addLabels = true;
    boolean addMessages = true;
    boolean recursive = true;

    public AddLabelsAndMessagesHandler(TagConfig config) {
        super(config);
        TagAttribute messages;
        TagAttribute labels;
        TagAttribute recursiveTag = config.getTag().getAttributes().get("recursive");
        if (null != recursiveTag && "false".equalsIgnoreCase(recursiveTag.getValue())) {
            this.recursive = false;
        }
        if (null != (labels = config.getTag().getAttributes().get("addLabels")) && "false".equalsIgnoreCase(labels.getValue())) {
            this.addLabels = false;
        }
        if (null != (messages = config.getTag().getAttributes().get("addMessages")) && "false".equalsIgnoreCase(messages.getValue())) {
            this.addMessages = false;
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (this.addLabels || this.addMessages) {
            this.populateTree(parent);
        }
    }

    private void populateTree(UIComponent parent) {
        List children = parent.getChildren();
        for (int index = children.size() - 1; index >= 0; --index) {
            UIComponent kid = (UIComponent)children.get(index);
            if (kid instanceof UIInput) {
                if (this.addMessages) {
                    this.addSingleMessage(children, index, kid);
                }
                if (this.addLabels) {
                    this.addSingleLabel(children, index, kid);
                }
            }
            if (!this.recursive) continue;
            this.populateTree(kid);
        }
    }

    private void addSingleLabel(List<UIComponent> children, int index, UIComponent kid) {
        boolean needsLabel = true;
        String addLabelAttribute = AttributeUtilities.getAttributeAsString(kid, "addLabel");
        if (null != addLabelAttribute && "false".equalsIgnoreCase(addLabelAttribute)) {
            needsLabel = false;
        }
        if (needsLabel) {
            ValueExpression vex;
            String caption = AttributeUtilities.getAttributeAsString(kid, "label");
            if (null == caption && null != (vex = kid.getValueExpression("value"))) {
                String core = vex.getExpressionString();
                caption = NGWordUtiltites.labelFromELExpression(core);
            }
            if (null != caption) {
                for (int j = 0; j < children.size(); ++j) {
                    UIComponent maybe = children.get(j);
                    if (!(maybe instanceof HtmlOutputLabel) || !kid.getId().equals(((HtmlOutputLabel)maybe).getFor())) continue;
                    needsLabel = false;
                }
                if (needsLabel) {
                    PuiLabel label = new PuiLabel();
                    label.getPassThroughAttributes().put("for", kid.getClientId());
                    kid.getAttributes().put("renderLabel", false);
                    label.setFor(kid.getId());
                    if (null != caption) {
                        label.setValue(this.translate(caption));
                    }
                    children.add(index, (UIComponent)label);
                }
            }
        }
    }

    private String translate(String caption) {
        if (null == this.i18n) {
            this.i18n = (I18n)ELTools.evalAsObject("#{i18n}");
        }
        if (null == this.i18n) {
            return caption;
        }
        return this.i18n.translate(caption);
    }

    private int addSingleMessage(List<UIComponent> children, int index, UIComponent kid) {
        if (kid instanceof UIInput && !(kid instanceof PuiSync)) {
            boolean needsMessage = true;
            String addMessageAttribute = AttributeUtilities.getAttributeAsString(kid, "addMessage");
            if (null != addMessageAttribute && "false".equalsIgnoreCase(addMessageAttribute)) {
                needsMessage = false;
            }
            if (needsMessage) {
                UIComponent forComponent;
                UIComponent maybe;
                if (index < children.size() - 1 && (maybe = children.get(index + 1)) instanceof PuiMessage && kid == (forComponent = maybe.findComponent(((UIMessage)maybe).getFor()))) {
                    needsMessage = false;
                }
                if (needsMessage) {
                    PuiMessage message = new PuiMessage();
                    message.setFor(kid.getClientId());
                    message.getPassThroughAttributes().put("for", kid.getClientId());
                    children.add(index + 1, (UIComponent)message);
                }
            }
        }
        return index;
    }
}

