/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.core.transformation;

import de.beyondjava.angularFaces.components.puiModelSync.PuiModelSync;
import de.beyondjava.angularFaces.core.tagTransformer.AngularTagDecorator;
import de.beyondjava.angularFaces.core.transformation.AddNGModelAndIDCallback;
import de.beyondjava.angularFaces.core.transformation.AddTypeInformationCallback;
import de.beyondjava.angularFaces.core.transformation.FindNGControllerCallback;
import de.beyondjava.angularFaces.core.transformation.FullVisitContext;
import de.beyondjava.angularFaces.core.transformation.TranslationCallback;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

public class PuiAngularTransformer
implements SystemEventListener {
    private static final Logger LOGGER = Logger.getLogger("de.beyondjava.angularFaces.core.transformation.PuiAngularTransformer");

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        Object source = event.getSource();
        if (source instanceof UIViewRoot) {
            long timer = System.nanoTime();
            final FacesContext context = FacesContext.getCurrentInstance();
            boolean isProduction = context.isProjectStage(ProjectStage.Production);
            if (!isProduction && !AngularTagDecorator.isActive()) {
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_FATAL, "Configuration error: ", "Add javax.faces.FACELETS_DECORATORS=de.beyondjava.angularFaces.core.tagTransformer.AngularTagDecorator to the context init parameters in the web.xml"));
                LOGGER.severe("Add javax.faces.FACELETS_DECORATORS=de.beyondjava.angularFaces.core.tagTransformer.AngularTagDecorator to the context init parameters in the web.xml");
            } else {
                boolean angularFacesRequest;
                final UIViewRoot root = (UIViewRoot)source;
                boolean ajaxRequest = context.getPartialViewContext().isAjaxRequest();
                boolean bl = angularFacesRequest = ajaxRequest && this.isAngularFacesRequest();
                if (!angularFacesRequest || PuiModelSync.isJSFAttributesTableEmpty()) {
                    PuiModelSync.initJSFAttributesTable();
                    FindNGControllerCallback ngControllerCallback = new FindNGControllerCallback();
                    LOGGER.fine((double)((System.nanoTime() - timer) / 1000L) / 1000.0 + " ms find NGControllerCallback");
                    root.visitTree((VisitContext)new FullVisitContext(context), (VisitCallback)ngControllerCallback);
                    if (!angularFacesRequest) {
                        this.addJavascript(root, context, isProduction);
                    }
                    this.time("add NGModel", new Runnable(){

                        @Override
                        public void run() {
                            root.visitTree((VisitContext)new FullVisitContext(context), (VisitCallback)new AddNGModelAndIDCallback());
                        }
                    });
                    this.time("add type information", new Runnable(){

                        @Override
                        public void run() {
                            root.visitTree((VisitContext)new FullVisitContext(context), (VisitCallback)new AddTypeInformationCallback());
                        }
                    });
                    if (!ajaxRequest) {
                        this.time("internationalization", new Runnable(){

                            @Override
                            public void run() {
                                root.visitTree((VisitContext)new FullVisitContext(context), (VisitCallback)new TranslationCallback());
                            }
                        });
                    }
                }
            }
            long time = System.nanoTime() - timer;
            LOGGER.fine((double)(time / 1000L) / 1000.0 + " ms");
        }
    }

    private void addJavascript(UIViewRoot root, FacesContext context, boolean isProduction) {
        UIOutput output = new UIOutput();
        output.setRendererType("javax.faces.resource.Script");
        if (isProduction) {
            output.getAttributes().put("name", "jquery.min-1.11.1.js");
        } else {
            output.getAttributes().put("name", "jquery-1.11.1.js");
        }
        output.getAttributes().put("library", "jQuery");
        root.addComponentResource(context, (UIComponent)output, "head");
        output = new UIOutput();
        output.setRendererType("javax.faces.resource.Script");
        if (isProduction) {
            output.getAttributes().put("name", "angular.min.js");
        } else {
            output.getAttributes().put("name", "angular.js");
        }
        output.getAttributes().put("library", "AngularJS");
        root.addComponentResource(context, (UIComponent)output, "head");
        output = new UIOutput();
        output.setRendererType("javax.faces.resource.Script");
        if (isProduction) {
            output.getAttributes().put("name", "jua-0.1.0-min.js");
        } else {
            output.getAttributes().put("name", "jua-0.1.0.js");
        }
        output.getAttributes().put("library", "AngularFaces");
        root.addComponentResource(context, (UIComponent)output, "head");
        output = new UIOutput();
        output.setRendererType("javax.faces.resource.Script");
        if (isProduction) {
            output.getAttributes().put("name", "angular-messages.min.js");
        } else {
            output.getAttributes().put("name", "angular-messages.js");
        }
        output.getAttributes().put("library", "AngularJS");
        root.addComponentResource(context, (UIComponent)output, "head");
        output = new UIOutput();
        output.setRendererType("javax.faces.resource.Script");
        if (isProduction) {
            output.getAttributes().put("name", "angularfaces.all.min.js");
        } else {
            output.getAttributes().put("name", "angularfaces-core.js");
        }
        output.getAttributes().put("library", "AngularFaces");
        root.addComponentResource(context, (UIComponent)output, "head");
        output = new UIOutput();
        output.setRendererType("javax.faces.resource.Script");
        if (!isProduction) {
            output.getAttributes().put("name", "angularfaces-directives.js");
        }
        output.getAttributes().put("library", "AngularFaces");
        root.addComponentResource(context, (UIComponent)output, "head");
        Locale locale = context.getExternalContext().getRequestLocale();
        String language = locale.getLanguage();
        UIOutput output2 = new UIOutput();
        output2.setRendererType("javax.faces.resource.Script");
        output2.getAttributes().put("name", "messages_" + language + ".js");
        output2.getAttributes().put("library", "AngularFaces");
        root.addComponentResource(context, (UIComponent)output2, "head");
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIComponent;
    }

    private void time(String description, Runnable runnable) {
        long timer = System.nanoTime();
        runnable.run();
        long time = System.nanoTime() - timer;
        LOGGER.fine((double)(time / 1000L) / 1000.0 + " ms " + description);
    }

    private boolean isAngularFacesRequest() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        PartialViewContext pvc = ctx.getPartialViewContext();
        Collection myRenderIds = pvc.getRenderIds();
        boolean isAngularFacesRequest = false;
        if (null != myRenderIds) {
            if (myRenderIds.contains("angular")) {
                isAngularFacesRequest = true;
            } else {
                for (Object id : myRenderIds) {
                    if (!(id instanceof String) || !((String)id).endsWith(":angular")) continue;
                    isAngularFacesRequest = true;
                    break;
                }
            }
        }
        return isAngularFacesRequest;
    }

    static {
        LOGGER.info("AngularFaces utility class PuiELTransformer ready for use.");
    }
}

