/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.core.transformation;

import de.beyondjava.angularFaces.components.puiModelSync.PuiModelSync;
import de.beyondjava.angularFaces.components.puiSync.PuiSync;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextWrapper;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.ClientWindow;

public class AngularViewContextWrapper
extends PartialViewContextWrapper {
    private static final String ORIGINAL_WRITER = "com.sun.faces.ORIGINAL_WRITER";
    private PartialViewContext wrapped;

    public AngularViewContextWrapper(PartialViewContext wrapped) {
        this.wrapped = wrapped;
    }

    public static String getViewStateId(FacesContext context) {
        String result = null;
        String viewStateCounterKey = "com.sun.faces.util.ViewStateCounterKey";
        Map contextAttrs = context.getAttributes();
        Integer counter = (Integer)contextAttrs.get("com.sun.faces.util.ViewStateCounterKey");
        if (null == counter) {
            counter = 0;
        }
        char sep = UINamingContainer.getSeparatorChar((FacesContext)context);
        UIViewRoot root = context.getViewRoot();
        result = root.getContainerClientId(context) + sep + "javax.faces.ViewState" + sep + counter;
        counter = counter + 1;
        contextAttrs.put("com.sun.faces.util.ViewStateCounterKey", counter);
        return result;
    }

    public static String getClientWindowId(FacesContext context) {
        String result = null;
        String clientWindowIdCounterKey = "com.sun.faces.util.ClientWindowCounterKey";
        Map contextAttrs = context.getAttributes();
        Integer counter = (Integer)contextAttrs.get("com.sun.faces.util.ClientWindowCounterKey");
        if (null == counter) {
            counter = 0;
        }
        char sep = UINamingContainer.getSeparatorChar((FacesContext)context);
        result = context.getViewRoot().getContainerClientId(context) + sep + "javax.faces.ClientWindow" + sep + counter;
        counter = counter + 1;
        contextAttrs.put("com.sun.faces.util.ClientWindowCounterKey", counter);
        return result;
    }

    public PartialViewContext getWrapped() {
        return this.wrapped;
    }

    public void processPartial(PhaseId phaseId) {
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES && this.isNGSyncRequest()) {
            this.applyNGSyncModelValues();
            return;
        }
        if (phaseId == PhaseId.RENDER_RESPONSE && this.isAjaxRequest() && this.isAngularFacesRequest()) {
            this.renderAngularResponse();
            return;
        }
        this.getWrapped().processPartial(phaseId);
    }

    private boolean isAngularFacesRequest() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        PartialViewContext pvc = ctx.getPartialViewContext();
        Collection myRenderIds = pvc.getRenderIds();
        boolean isAngularFacesRequest = false;
        if (null != myRenderIds) {
            if (myRenderIds.contains("angular")) {
                isAngularFacesRequest = true;
            } else {
                for (Object id : myRenderIds) {
                    if (!(id instanceof String) || !((String)id).endsWith(":angular")) continue;
                    isAngularFacesRequest = true;
                    break;
                }
            }
        }
        return isAngularFacesRequest;
    }

    private void applyNGSyncModelValues() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        PartialViewContext pvc = ctx.getPartialViewContext();
        Collection executeIDs = pvc.getExecuteIds();
        if (null != executeIDs) {
            for (String clientID : executeIDs) {
                UIViewRoot viewRoot = ctx.getViewRoot();
                UIComponent c = viewRoot.findComponent(clientID);
                if (!(c instanceof PuiSync) || !c.isInView()) continue;
                c.decode(ctx);
            }
        }
    }

    private boolean isNGSyncRequest() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        boolean isAngularFacesRequest = false;
        String action = (String)ctx.getExternalContext().getRequestParameterMap().get("de.beyondjava.angularfaces.behavior.event");
        if ("ngsync".equals(action)) {
            isAngularFacesRequest = true;
        }
        return isAngularFacesRequest;
    }

    private void renderAngularResponse() {
        try {
            FacesContext ctx = FacesContext.getCurrentInstance();
            PartialViewContext pvc = ctx.getPartialViewContext();
            UIViewRoot viewRoot = ctx.getViewRoot();
            PartialResponseWriter writer = pvc.getPartialResponseWriter();
            ResponseWriter orig = ctx.getResponseWriter();
            ctx.getAttributes().put(ORIGINAL_WRITER, orig);
            ctx.setResponseWriter((ResponseWriter)writer);
            ExternalContext exContext = ctx.getExternalContext();
            exContext.setResponseContentType("text/xml");
            exContext.addResponseHeader("Cache-Control", "no-cache");
            String encoding = writer.getCharacterEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            writer.writePreamble("<?xml version='1.0' encoding='" + encoding + "'?>");
            writer.startDocument();
            writer.startEval();
            this.encodeAngularScript((ResponseWriter)writer, ctx);
            writer.endEval();
            this.renderState(ctx);
            writer.endDocument();
        }
        catch (IOException ex) {
            this.cleanupAfterView();
        }
        catch (RuntimeException ex) {
            this.cleanupAfterView();
            throw ex;
        }
    }

    private void cleanupAfterView() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ResponseWriter orig = (ResponseWriter)ctx.getAttributes().get(ORIGINAL_WRITER);
        assert (null != orig);
        ctx.setResponseWriter(orig);
    }

    private void renderState(FacesContext context) throws IOException {
        PartialViewContext pvc = context.getPartialViewContext();
        PartialResponseWriter writer = pvc.getPartialResponseWriter();
        String viewStateId = AngularViewContextWrapper.getViewStateId(context);
        writer.startUpdate(viewStateId);
        String state = context.getApplication().getStateManager().getViewState(context);
        writer.write(state);
        writer.endUpdate();
        ClientWindow window = context.getExternalContext().getClientWindow();
        if (null != window) {
            String clientWindowId = AngularViewContextWrapper.getClientWindowId(context);
            writer.startUpdate(clientWindowId);
            writer.write(window.getId());
            writer.endUpdate();
        }
    }

    public void encodeAngularScript(ResponseWriter writer, FacesContext context) throws IOException {
        List<String> beansAsJSon = PuiModelSync.getFacesModel();
        for (String bean : beansAsJSon) {
            writer.write("puiUpdateModel(" + bean + ");");
        }
    }
}

